/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.templates;

import com.algorand.algosdk.account.Account;
import com.algorand.algosdk.builder.transaction.PaymentTransactionBuilder;
import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.logic.Logic;
import com.algorand.algosdk.templates.ContractTemplate;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.Encoder;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.util.Arrays;

@Deprecated
public class HTLC {
    private static String referenceProgram = "ASAEBQEABiYDIP68oLsUSlpOp7Q4pGgayA5soQW8tgf8VlMlyVaV9qITAQYg5pqWHm8tX3rIZgeSZVK+mCNe0zNjyoiRi7nJOKkVtvkxASIOMRAjEhAxBzIDEhAxCCQSEDEJKBItASkSEDEJKhIxAiUNEBEQ";

    public static ContractTemplate MakeHTLC(Address owner, Address receiver, String hashFunction, String hashImage, int expiryRound, int maxFee) throws NoSuchAlgorithmException {
        int hashInject;
        if (hashFunction.equals("sha256")) {
            hashInject = 1;
        } else if (hashFunction.equals("keccak256")) {
            hashInject = 2;
        } else {
            throw new RuntimeException("invalid hash function supplied");
        }
        ImmutableList values = ImmutableList.of((Object)new ContractTemplate.IntParameterValue(3, maxFee), (Object)new ContractTemplate.IntParameterValue(6, expiryRound), (Object)new ContractTemplate.AddressParameterValue(10, receiver), (Object)new ContractTemplate.BytesParameterValue(42, hashImage), (Object)new ContractTemplate.AddressParameterValue(45, owner), (Object)new ContractTemplate.IntParameterValue(102, hashInject));
        return ContractTemplate.inject(Encoder.decodeFromBase64(referenceProgram), (List<ContractTemplate.ParameterValue>)values);
    }

    public static SignedTransaction GetHTLCTransaction(ContractTemplate contract, String preImage, int firstValid, int lastValid, Digest genesisHash, int feePerByte) throws NoSuchAlgorithmException, IOException {
        byte[] computedImage;
        MessageDigest digest;
        Logic.ProgramData data = ContractTemplate.readAndVerifyContract(contract.program, 4, 3);
        int maxFee = data.intBlock.get(0);
        Address receiver = new Address(data.byteBlock.get(0));
        byte[] hashImage = data.byteBlock.get(1);
        int hashFunction = contract.program[contract.program.length - 15];
        if (hashFunction == 1) {
            digest = MessageDigest.getInstance("SHA-256");
            computedImage = digest.digest(Encoder.decodeFromBase64(preImage));
            if (Arrays.compareUnsigned((byte[])computedImage, (byte[])hashImage) != 0) {
                throw new RuntimeException("Unable to verify SHA-256 preImage: sha256(preimage) != image");
            }
        } else if (hashFunction == 2) {
            try {
                digest = new Keccak.Digest256();
                computedImage = digest.digest(Encoder.decodeFromBase64(preImage));
                if (Arrays.compareUnsigned((byte[])computedImage, (byte[])hashImage) != 0) {
                    throw new RuntimeException("Unable to verify Keccak-256 preImage: keccak256(preimage) != image");
                }
            }
            catch (Exception digest2) {}
        } else {
            throw new RuntimeException("Invalid contract detected, unable to find a valid hash function ID.");
        }
        Transaction txn = ((TransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)Transaction.PaymentTransactionBuilder().sender(contract.address)).fee(0)).firstValid(firstValid)).lastValid(lastValid)).genesisHash(genesisHash)).amount(0)).closeRemainderTo(receiver)).build();
        Account.setFeeByFeePerByte(txn, feePerByte);
        if (txn.fee.intValue() > maxFee) {
            throw new RuntimeException("Transaction fee is too high: " + txn.fee.intValue() + " > " + maxFee);
        }
        ImmutableList args = ImmutableList.of((Object)Encoder.decodeFromBase64(preImage));
        LogicsigSignature lsig = new LogicsigSignature(contract.program, (List<byte[]>)args);
        return new SignedTransaction(txn, lsig);
    }
}

