/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.templates;

import com.algorand.algosdk.account.Account;
import com.algorand.algosdk.builder.transaction.PaymentTransactionBuilder;
import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.builder.transaction.TransactionParametersBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.logic.Logic;
import com.algorand.algosdk.templates.ContractTemplate;
import com.algorand.algosdk.transaction.Lease;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TxGroup;
import com.algorand.algosdk.util.Encoder;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;

@Deprecated
public class DynamicFee {
    protected static String referenceProgram = "ASAFAgEFBgcmAyD+vKC7FEpaTqe0OKRoGsgObKEFvLYH/FZTJclWlfaiEyDmmpYeby1feshmB5JlUr6YI17TM2PKiJGLuck4qRW2+QEGMgQiEjMAECMSEDMABzEAEhAzAAgxARIQMRYjEhAxECMSEDEHKBIQMQkpEhAxCCQSEDECJRIQMQQhBBIQMQYqEhA=";

    public static ContractTemplate MakeDynamicFee(Address receiver, Integer amount, Integer firstValid, Integer lastValid, Address closeRemainderAddress) throws NoSuchAlgorithmException {
        return DynamicFee.MakeDynamicFee(receiver, amount, firstValid, lastValid, closeRemainderAddress, null);
    }

    protected static ContractTemplate MakeDynamicFee(Address receiver, Integer amount, Integer firstValid, Integer lastValid, Address closeRemainderAddress, Lease lease) throws NoSuchAlgorithmException {
        Objects.requireNonNull(receiver);
        Objects.requireNonNull(amount);
        Objects.requireNonNull(firstValid);
        byte[] program = Encoder.decodeFromBase64(referenceProgram);
        ImmutableList values = ImmutableList.of((Object)new ContractTemplate.IntParameterValue(5, amount), (Object)new ContractTemplate.IntParameterValue(6, firstValid), (Object)new ContractTemplate.IntParameterValue(7, lastValid == null ? firstValid + 1000 : lastValid), (Object)new ContractTemplate.AddressParameterValue(11, receiver), (Object)new ContractTemplate.AddressParameterValue(44, closeRemainderAddress == null ? new Address() : closeRemainderAddress), (Object)new ContractTemplate.BytesParameterValue(76, lease == null ? new Lease() : lease));
        return ContractTemplate.inject(program, (List<ContractTemplate.ParameterValue>)values);
    }

    public static SignedDynamicFee SignDynamicFee(ContractTemplate contract, Account senderAccount, Digest genesisHash) throws IOException {
        Logic.ProgramData data = ContractTemplate.readAndVerifyContract(contract.program, 5, 3);
        Address receiverAddress = new Address(data.byteBlock.get(0));
        Address closeToAddress = new Address(data.byteBlock.get(1));
        Lease lease = new Lease(data.byteBlock.get(2));
        BigInteger amount = BigInteger.valueOf(data.intBlock.get(2).intValue());
        BigInteger firstValid = BigInteger.valueOf(data.intBlock.get(3).intValue());
        BigInteger lastValid = BigInteger.valueOf(data.intBlock.get(4).intValue());
        Transaction txn = ((PaymentTransactionBuilder)((TransactionParametersBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)Transaction.PaymentTransactionBuilder().sender(senderAccount.getAddress())).flatFee(Account.MIN_TX_FEE_UALGOS)).firstValid(firstValid)).lastValid(lastValid)).genesisHash(genesisHash)).amount(amount)).receiver(receiverAddress)).closeRemainderTo(closeToAddress)).lease(lease)).build();
        LogicsigSignature lsig = senderAccount.signLogicsig(new LogicsigSignature(contract.program));
        return new SignedDynamicFee(txn, lsig);
    }

    public static byte[] MakeReimbursementTransactions(Transaction txn, LogicsigSignature lsig, Account account, int feePerByte) throws NoSuchAlgorithmException, IOException {
        Account.setFeeByFeePerByte(txn, BigInteger.valueOf(feePerByte));
        Transaction txn2 = ((TransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)((PaymentTransactionBuilder)Transaction.PaymentTransactionBuilder().sender(account.getAddress())).fee(feePerByte)).firstValid(txn.firstValid)).lastValid(txn.lastValid)).genesisID(txn.genesisID)).genesisHash(txn.genesisHash)).amount(txn.fee)).receiver(txn.sender)).build();
        txn2.setLease(new Lease(txn.lease));
        Account.setFeeByFeePerByte(txn2, BigInteger.valueOf(feePerByte));
        TxGroup.assignGroupID(txn2, txn);
        SignedTransaction stx1 = new SignedTransaction(txn, lsig, txn.txID());
        SignedTransaction stx2 = account.signTransaction(txn2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(Encoder.encodeToMsgPack(stx2));
        baos.write(Encoder.encodeToMsgPack(stx1));
        return baos.toByteArray();
    }

    public static class SignedDynamicFee {
        public final Transaction txn;
        public final LogicsigSignature lsig;

        private SignedDynamicFee(Transaction txn, LogicsigSignature lsig) {
            this.txn = txn;
            this.lsig = lsig;
        }
    }
}

