/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.templates;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.logic.Logic;
import com.algorand.algosdk.transaction.Lease;
import com.algorand.algosdk.util.Encoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ContractTemplate {
    public Address address;
    public byte[] program;

    public ContractTemplate(String prog) throws NoSuchAlgorithmException {
        this(Encoder.decodeFromBase64(prog));
    }

    public ContractTemplate(byte[] prog) throws NoSuchAlgorithmException {
        this(new LogicsigSignature(prog));
    }

    public ContractTemplate(LogicsigSignature lsig) throws NoSuchAlgorithmException {
        this.address = lsig.toAddress();
        this.program = lsig.logic;
    }

    protected static ContractTemplate inject(byte[] program, List<ParameterValue> values) throws NoSuchAlgorithmException {
        ArrayList<Byte> updatedProgram = new ArrayList<Byte>();
        int progIdx = 0;
        for (ParameterValue value : values) {
            while (progIdx < value.getOffset()) {
                updatedProgram.add(program[progIdx++]);
            }
            for (byte b : value.toBytes()) {
                updatedProgram.add(b);
            }
            progIdx += value.placeholderSize();
        }
        while (progIdx < program.length) {
            updatedProgram.add(program[progIdx++]);
        }
        byte[] updatedProgramByteArray = new byte[updatedProgram.size()];
        for (int x = 0; x < updatedProgram.size(); ++x) {
            updatedProgramByteArray[x] = (Byte)updatedProgram.get(x);
        }
        return new ContractTemplate(updatedProgramByteArray);
    }

    protected static Logic.ProgramData readAndVerifyContract(byte[] program, int numInts, int numByteArrays) {
        Logic.ProgramData data;
        try {
            data = Logic.readProgram(program, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse contract.");
        }
        if (!data.good || data.intBlock.size() != numInts || data.byteBlock.size() != numByteArrays) {
            throw new IllegalArgumentException("Invalid contract detected.");
        }
        return data;
    }

    static abstract class ParameterValue {
        private final int offset;
        private final byte[] value;

        protected ParameterValue(int offset, byte[] value) {
            this.value = value;
            this.offset = offset;
        }

        public byte[] toBytes() {
            return this.value;
        }

        public int getOffset() {
            return this.offset;
        }

        public abstract int placeholderSize();
    }

    public static class BytesParameterValue
    extends ParameterValue {
        public BytesParameterValue(int offset, String value) {
            this(offset, Encoder.decodeFromBase64(value));
        }

        public BytesParameterValue(int offset, byte[] value) {
            super(offset, BytesParameterValue.convertToBytes(value));
        }

        public BytesParameterValue(int offset, Lease value) {
            this(offset, value.getBytes());
        }

        private static byte[] convertToBytes(byte[] value) {
            byte[] len = Logic.putUVarint(value.length);
            byte[] result = new byte[len.length + value.length];
            System.arraycopy(len, 0, result, 0, len.length);
            System.arraycopy(value, 0, result, len.length, value.length);
            return result;
        }

        @Override
        public int placeholderSize() {
            return 2;
        }
    }

    public static class AddressParameterValue
    extends ParameterValue {
        public AddressParameterValue(int offset, String value) throws NoSuchAlgorithmException {
            super(offset, new Address(value).getBytes());
        }

        public AddressParameterValue(int offset, Address address) throws NoSuchAlgorithmException {
            super(offset, address.getBytes());
        }

        public AddressParameterValue(int offset, byte[] value) throws NoSuchAlgorithmException {
            super(offset, value);
        }

        @Override
        public int placeholderSize() {
            return 32;
        }
    }

    public static class IntParameterValue
    extends ParameterValue {
        public IntParameterValue(int offset, int value) {
            super(offset, Logic.putUVarint(value));
        }

        @Override
        public int placeholderSize() {
            return 1;
        }
    }
}

