/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.mnemonic;

import com.algorand.algosdk.mnemonic.Wordlist;
import com.algorand.algosdk.util.CryptoProvider;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;

public class Mnemonic {
    private static final int BITS_PER_WORD = 11;
    private static final int CHECKSUM_LEN_WORDS = 1;
    private static final int KEY_LEN_BYTES = 32;
    private static final int MNEM_LEN_WORDS = 25;
    private static final int PADDING_ZEROS = 8;
    private static final String CHECKSUM_ALG = "SHA-512/256";
    private static final String MNEMONIC_DELIM = " ";

    public static String fromKey(byte[] key) {
        Objects.requireNonNull(key, "key must not be null");
        if (key.length != 32) {
            throw new IllegalArgumentException("key length must be 32 bytes");
        }
        String chkWord = Mnemonic.checksum(key);
        int[] uint11Arr = Mnemonic.toUintNArray(key);
        String[] words = Mnemonic.applyWords(uint11Arr);
        return Mnemonic.mnemonicToString(words, chkWord);
    }

    public static byte[] toKey(String mnemonicStr) throws GeneralSecurityException {
        int i;
        Objects.requireNonNull(mnemonicStr, "mnemonic must not be null");
        String[] mnemonic = mnemonicStr.split(MNEMONIC_DELIM);
        if (mnemonic.length != 25) {
            throw new IllegalArgumentException("mnemonic does not have enough words");
        }
        int numWords = 24;
        int[] uint11Arr = new int[numWords];
        for (i = 0; i < numWords; ++i) {
            uint11Arr[i] = -1;
        }
        for (int w = 0; w < Wordlist.RAW.length; ++w) {
            for (int i2 = 0; i2 < numWords; ++i2) {
                if (!Wordlist.RAW[w].equals(mnemonic[i2])) continue;
                uint11Arr[i2] = w;
            }
        }
        for (i = 0; i < numWords; ++i) {
            if (uint11Arr[i] != -1) continue;
            throw new IllegalArgumentException("mnemonic contains word that is not in word list");
        }
        byte[] b = Mnemonic.toByteArray(uint11Arr);
        if (b.length != 33) {
            throw new GeneralSecurityException("wrong key length");
        }
        if (b[32] != 0) {
            throw new GeneralSecurityException("unexpected byte from key");
        }
        byte[] bCopy = Arrays.copyOf(b, 32);
        String chkWord = Mnemonic.checksum(bCopy);
        if (!chkWord.equals(mnemonic[24])) {
            throw new GeneralSecurityException("checksum failed to validate");
        }
        return Arrays.copyOf(b, 32);
    }

    protected static String checksum(byte[] data) {
        try {
            CryptoProvider.setupIfNeeded();
            MessageDigest digest = MessageDigest.getInstance(CHECKSUM_ALG);
            digest.update(Arrays.copyOf(data, data.length));
            byte[] d = digest.digest();
            d = Arrays.copyOfRange(d, 0, 2);
            return Mnemonic.applyWord(Mnemonic.toUintNArray(d)[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static int[] toUintNArray(byte[] arr) {
        int buffer = 0;
        int numBits = 0;
        int[] out = new int[(arr.length * 8 + 11 - 1) / 11];
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            int v = arr[i];
            if (v < 0) {
                v += 256;
            }
            buffer |= v << numBits;
            if ((numBits += 8) < 11) continue;
            out[j] = buffer & 0x7FF;
            ++j;
            buffer >>= 11;
            numBits -= 11;
        }
        if (numBits != 0) {
            out[j] = buffer & 0x7FF;
        }
        return out;
    }

    private static byte[] toByteArray(int[] arr) {
        int buffer = 0;
        int numBits = 0;
        byte[] out = new byte[(arr.length * 11 + 8 - 1) / 8];
        int j = 0;
        for (int i = 0; i < arr.length; ++i) {
            buffer |= arr[i] << numBits;
            numBits += 11;
            while (numBits >= 8) {
                out[j] = (byte)(buffer & 0xFF);
                ++j;
                buffer >>= 8;
                numBits -= 8;
            }
        }
        if (numBits != 0) {
            out[j] = (byte)(buffer & 0xFF);
        }
        return out;
    }

    private static String applyWord(int iN) {
        return Wordlist.RAW[iN];
    }

    private static String[] applyWords(int[] arrN) {
        String[] ret = new String[arrN.length];
        for (int i = 0; i < arrN.length; ++i) {
            ret[i] = Mnemonic.applyWord(arrN[i]);
        }
        return ret;
    }

    private static String mnemonicToString(String[] mnemonic, String checksum) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < mnemonic.length; ++i) {
            if (i > 0) {
                s.append(MNEMONIC_DELIM);
            }
            s.append(mnemonic[i]);
        }
        s.append(MNEMONIC_DELIM);
        s.append(checksum);
        return s.toString();
    }
}

