/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.logic;

import java.util.ArrayList;
import java.util.HashMap;

public class SourceMap {
    public int version;
    public String file;
    public String[] sources;
    public String[] names;
    public String mappings;
    public HashMap<Integer, Integer> pcToLine;
    public HashMap<Integer, ArrayList<Integer>> lineToPc;

    public SourceMap(HashMap<String, Object> sourceMap) {
        int version = (Integer)sourceMap.get("version");
        if (version != 3) {
            throw new IllegalArgumentException("Only source map version 3 is supported");
        }
        this.version = version;
        this.file = (String)sourceMap.get("file");
        this.mappings = (String)sourceMap.get("mappings");
        this.lineToPc = new HashMap();
        this.pcToLine = new HashMap();
        Integer lastLine = 0;
        String[] vlqs = this.mappings.split(";");
        for (int i = 0; i < vlqs.length; ++i) {
            ArrayList<Integer> vals = VLQDecoder.decodeSourceMapLine(vlqs[i]);
            if (vals.size() >= 3) {
                lastLine = lastLine + vals.get(2);
            }
            if (!this.lineToPc.containsKey(lastLine)) {
                this.lineToPc.put(lastLine, new ArrayList());
            }
            ArrayList<Integer> currList = this.lineToPc.get(lastLine);
            currList.add(i);
            this.lineToPc.put(lastLine, currList);
            this.pcToLine.put(i, lastLine);
        }
    }

    public Integer getLineForPc(Integer pc) {
        return this.pcToLine.get(pc);
    }

    public ArrayList<Integer> getPcsForLine(Integer line) {
        if (!this.pcToLine.containsKey(line)) {
            return new ArrayList<Integer>();
        }
        return this.lineToPc.get(line);
    }

    private static class VLQDecoder {
        private static final String b64table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        private static final int vlqShiftSize = 5;
        private static final int vlqFlag = 32;
        private static final int vlqMask = 31;

        private VLQDecoder() {
        }

        public static ArrayList<Integer> decodeSourceMapLine(String vlq) {
            ArrayList<Integer> results = new ArrayList<Integer>();
            int value = 0;
            int shift = 0;
            for (int i = 0; i < vlq.length(); ++i) {
                int digit = b64table.indexOf(vlq.charAt(i));
                value |= (digit & 0x1F) << shift;
                if ((digit & 0x20) > 0) {
                    shift += 5;
                    continue;
                }
                value = (value & 1) > 0 ? (value >> 1) * -1 : (value >>= 1);
                results.add(value);
                value = 0;
                shift = 0;
            }
            return results;
        }
    }
}

