/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.logic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class Logic {
    private static final int MAX_COST = 20000;
    private static final int MAX_LENGTH = 1000;
    private static final int INTCBLOCK_OPCODE = 32;
    private static final int BYTECBLOCK_OPCODE = 38;
    private static final int PUSHBYTES_OPCODE = 128;
    private static final int PUSHINT_OPCODE = 129;
    private static LangSpec langSpec;
    private static Operation[] opcodes;

    public static byte[] putUVarint(int value) {
        assert (value >= 0) : "putUVarint expects non-negative values.";
        ArrayList<Byte> buffer = new ArrayList<Byte>();
        while (value >= 128) {
            buffer.add((byte)(value & 0xFF | 0x80));
            value >>= 7;
        }
        buffer.add((byte)(value & 0xFF));
        byte[] out = new byte[buffer.size()];
        for (int x = 0; x < buffer.size(); ++x) {
            out[x] = (Byte)buffer.get(x);
        }
        return out;
    }

    public static VarintResult getUVarint(byte[] buffer, int bufferOffset) {
        int x = 0;
        int s = 0;
        for (int i = 0; i < buffer.length; ++i) {
            int b = buffer[bufferOffset + i] & 0xFF;
            if (b < 128) {
                if (i > 9 || i == 9 && b > 1) {
                    return new VarintResult(0, -(i + 1));
                }
                return new VarintResult(x | (b & 0xFF) << s, i + 1);
            }
            x |= (b & 0x7F & 0xFF) << s;
            s += 7;
        }
        return new VarintResult();
    }

    public static boolean checkProgram(byte[] program, List<byte[]> args) throws IOException {
        return Logic.readProgram((byte[])program, args).good;
    }

    public static ProgramData readProgram(byte[] program, List<byte[]> args) throws IOException {
        int size;
        int i;
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        if (langSpec == null) {
            Logic.loadLangSpec();
        }
        VarintResult result = Logic.getUVarint(program, 0);
        int vlen = result.length;
        if (vlen <= 0) {
            throw new IllegalArgumentException("version parsing error");
        }
        int version = result.value;
        if (version > Logic.langSpec.EvalMaxVersion) {
            throw new IllegalArgumentException("unsupported version");
        }
        if (args == null) {
            args = new ArrayList<byte[]>();
        }
        int cost = 0;
        int length = program.length;
        for (i = 0; i < args.size(); ++i) {
            length += args.get(i).length;
        }
        if (length > 1000) {
            throw new IllegalArgumentException("program too long");
        }
        if (opcodes == null) {
            opcodes = new Operation[256];
            for (i = 0; i < Logic.langSpec.Ops.length; ++i) {
                Operation op;
                Logic.opcodes[op.Opcode] = op = Logic.langSpec.Ops[i];
            }
        }
        block8: for (int pc = vlen; pc < program.length; pc += size) {
            int opcode = program[pc] & 0xFF;
            Operation op = opcodes[opcode];
            if (op == null) {
                throw new IllegalArgumentException("invalid instruction: " + opcode);
            }
            cost += op.Cost;
            size = op.Size;
            if (size != 0) continue;
            switch (op.Opcode) {
                case 32: {
                    IntConstBlock intsBlock = Logic.readIntConstBlock(program, pc);
                    size += intsBlock.size;
                    ints.addAll(intsBlock.results);
                    continue block8;
                }
                case 38: {
                    ByteConstBlock bytesBlock = Logic.readByteConstBlock(program, pc);
                    size += bytesBlock.size;
                    bytes.addAll(bytesBlock.results);
                    continue block8;
                }
                case 129: {
                    IntConstBlock pushInt = Logic.readPushIntOp(program, pc);
                    size += pushInt.size;
                    ints.addAll(pushInt.results);
                    continue block8;
                }
                case 128: {
                    ByteConstBlock pushBytes = Logic.readPushByteOp(program, pc);
                    size += pushBytes.size;
                    bytes.addAll(pushBytes.results);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("invalid instruction");
                }
            }
        }
        if (version < 4 && cost > 20000) {
            throw new IllegalArgumentException("program too costly for version < 4. consider using v4.");
        }
        return new ProgramData(true, ints, bytes);
    }

    public static int getLogicSigVersion() throws IOException {
        if (langSpec == null) {
            Logic.loadLangSpec();
        }
        return Logic.langSpec.LogicSigVersion;
    }

    public static int getEvalMaxVersion() throws IOException {
        if (langSpec == null) {
            Logic.loadLangSpec();
        }
        return Logic.langSpec.EvalMaxVersion;
    }

    private static void loadLangSpec() throws IOException {
        InputStreamReader reader;
        if (langSpec != null) {
            return;
        }
        try {
            reader = new InputStreamReader(Logic.class.getResourceAsStream("/langspec.json"), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("langspec opening error");
        }
        Gson g = new GsonBuilder().create();
        langSpec = (LangSpec)g.fromJson((Reader)reader, LangSpec.class);
        ((Reader)reader).close();
    }

    protected static IntConstBlock readIntConstBlock(byte[] program, int pc) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        int size = 1;
        VarintResult result = Logic.getUVarint(program, pc + size);
        if (result.length <= 0) {
            throw new IllegalArgumentException(String.format("could not decode int const block at pc=%d", pc));
        }
        size += result.length;
        int numInts = result.value;
        for (int i = 0; i < numInts; ++i) {
            if (pc + size >= program.length) {
                throw new IllegalArgumentException("int const block exceeds program length");
            }
            result = Logic.getUVarint(program, pc + size);
            if (result.length <= 0) {
                throw new IllegalArgumentException(String.format("could not decode int const[%d] block at pc=%d", i, pc + size));
            }
            size += result.length;
            results.add(result.value);
        }
        return new IntConstBlock(size, results);
    }

    protected static ByteConstBlock readByteConstBlock(byte[] program, int pc) {
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        int size = 1;
        VarintResult result = Logic.getUVarint(program, pc + size);
        if (result.length <= 0) {
            throw new IllegalArgumentException(String.format("could not decode byte[] const block at pc=%d", pc));
        }
        size += result.length;
        int numInts = result.value;
        for (int i = 0; i < numInts; ++i) {
            if (pc + size >= program.length) {
                throw new IllegalArgumentException("byte[] const block exceeds program length");
            }
            result = Logic.getUVarint(program, pc + size);
            if (result.length <= 0) {
                throw new IllegalArgumentException(String.format("could not decode byte[] const[%d] block at pc=%d", i, pc + size));
            }
            if (pc + (size += result.length) + result.value > program.length) {
                throw new IllegalArgumentException("byte[] const block exceeds program length");
            }
            byte[] buff = new byte[result.value];
            System.arraycopy(program, pc + size, buff, 0, result.value);
            results.add(buff);
            size += result.value;
        }
        return new ByteConstBlock(size, results);
    }

    protected static IntConstBlock readPushIntOp(byte[] program, int pc) {
        int size = 1;
        VarintResult result = Logic.getUVarint(program, pc + size);
        if (result.length <= 0) {
            throw new IllegalArgumentException(String.format("could not decode push int const at pc=%d", pc));
        }
        return new IntConstBlock(size += result.length, Collections.singletonList(result.value));
    }

    protected static ByteConstBlock readPushByteOp(byte[] program, int pc) {
        int size = 1;
        VarintResult result = Logic.getUVarint(program, pc + size);
        if (result.length <= 0) {
            throw new IllegalArgumentException(String.format("could not decode push []byte const size at pc=%d", pc));
        }
        if (pc + (size += result.length) + result.value > program.length) {
            throw new IllegalArgumentException("pushbytes ran past end of program");
        }
        byte[] buff = new byte[result.value];
        System.arraycopy(program, pc + size, buff, 0, result.value);
        return new ByteConstBlock(size += result.value, Collections.singletonList(buff));
    }

    public static class VarintResult {
        public final int value;
        public final int length;

        private VarintResult(int value, int length) {
            this.value = value;
            this.length = length;
        }

        private VarintResult() {
            this.value = 0;
            this.length = 0;
        }
    }

    public static class ProgramData {
        public final boolean good;
        public final List<Integer> intBlock;
        public final List<byte[]> byteBlock;

        private ProgramData(boolean good, List<Integer> intBlock, List<byte[]> byteBlock) {
            this.good = good;
            this.intBlock = intBlock;
            this.byteBlock = byteBlock;
        }
    }

    private class LangSpec {
        public int EvalMaxVersion;
        public int LogicSigVersion;
        public Operation[] Ops;

        private LangSpec() {
        }
    }

    private class Operation {
        int Opcode;
        String Name;
        int Cost;
        int Size;
        String Returns;
        String[] ArgEnum;
        String ArgEnumTypes;
        String Doc;
        String ImmediateNote;
        String[] Group;

        private Operation() {
        }
    }

    protected static class IntConstBlock {
        public final int size;
        public final List<Integer> results;

        IntConstBlock(int size, List<Integer> results) {
            this.size = size;
            this.results = results;
        }
    }

    protected static class ByteConstBlock {
        public final int size;
        public final List<byte[]> results;

        ByteConstBlock(int size, List<byte[]> results) {
            this.size = size;
            this.results = results;
        }
    }
}

