/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.kmd.client.model;

import com.algorand.algosdk.crypto.Ed25519PublicKey;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="APIV1POSTMultisigImportRequest is the request for `POST /v1/multisig/import`")
public class ImportMultisigRequest {
    @SerializedName(value="multisig_version")
    private Integer multisigVersion = null;
    @SerializedName(value="pks")
    private List<byte[]> pks = null;
    @SerializedName(value="threshold")
    private Integer threshold = null;
    @SerializedName(value="wallet_handle_token")
    private String walletHandleToken = null;

    public ImportMultisigRequest multisigVersion(Integer multisigVersion) {
        this.multisigVersion = multisigVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getMultisigVersion() {
        return this.multisigVersion;
    }

    public void setMultisigVersion(Integer multisigVersion) {
        this.multisigVersion = multisigVersion;
    }

    public ImportMultisigRequest pks(List<Ed25519PublicKey> pks) {
        if (this.pks == null) {
            this.pks = new ArrayList<byte[]>();
        }
        for (Ed25519PublicKey pk : pks) {
            this.pks.add(pk.getBytes());
        }
        return this;
    }

    public ImportMultisigRequest addPksItem(Ed25519PublicKey pksItem) {
        if (this.pks == null) {
            this.pks = new ArrayList<byte[]>();
        }
        this.pks.add(pksItem.getBytes());
        return this;
    }

    @ApiModelProperty(value="")
    public List<Ed25519PublicKey> getPks() {
        ArrayList<Ed25519PublicKey> pkObjs = new ArrayList<Ed25519PublicKey>();
        for (byte[] pk : this.pks) {
            pkObjs.add(new Ed25519PublicKey(pk));
        }
        return pkObjs;
    }

    public void setPks(List<Ed25519PublicKey> pks) {
        if (this.pks == null) {
            this.pks = new ArrayList<byte[]>();
        }
        for (Ed25519PublicKey pk : pks) {
            this.pks.add(pk.getBytes());
        }
    }

    public ImportMultisigRequest threshold(Integer threshold) {
        this.threshold = threshold;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public ImportMultisigRequest walletHandleToken(String walletHandleToken) {
        this.walletHandleToken = walletHandleToken;
        return this;
    }

    @ApiModelProperty(value="")
    public String getWalletHandleToken() {
        return this.walletHandleToken;
    }

    public void setWalletHandleToken(String walletHandleToken) {
        this.walletHandleToken = walletHandleToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportMultisigRequest importMultisigRequest = (ImportMultisigRequest)o;
        return ObjectUtils.equals((Object)this.multisigVersion, (Object)importMultisigRequest.multisigVersion) && ObjectUtils.equals(this.pks, importMultisigRequest.pks) && ObjectUtils.equals((Object)this.threshold, (Object)importMultisigRequest.threshold) && ObjectUtils.equals((Object)this.walletHandleToken, (Object)importMultisigRequest.walletHandleToken);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.multisigVersion, this.pks, this.threshold, this.walletHandleToken});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportMultisigRequest {\n");
        sb.append("    multisigVersion: ").append(this.toIndentedString(this.multisigVersion)).append("\n");
        sb.append("    pks: ").append(this.toIndentedString(this.pks)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("    walletHandleToken: ").append(this.toIndentedString(this.walletHandleToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

