/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class VRFPublicKey
implements Serializable {
    private static final int KEY_LEN_BYTES = 32;
    private final byte[] bytes = new byte[32];

    @JsonCreator
    public VRFPublicKey(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        if (bytes.length != 32) {
            throw new IllegalArgumentException("vrf key wrong length");
        }
        System.arraycopy(bytes, 0, this.bytes, 0, 32);
    }

    public VRFPublicKey() {
    }

    @JsonValue
    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object obj) {
        return obj instanceof VRFPublicKey && Arrays.equals(this.bytes, ((VRFPublicKey)obj).bytes);
    }
}

