/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Signature
implements Serializable {
    @JsonIgnore
    private static final int ED25519_SIG_SIZE = 64;
    @JsonProperty(value="bytes")
    private final byte[] bytes = new byte[64];

    @JsonCreator
    public Signature(byte[] rawBytes) {
        if (rawBytes == null) {
            return;
        }
        if (rawBytes.length != 64) {
            throw new IllegalArgumentException(String.format("Given signature length is not %s", 64));
        }
        System.arraycopy(rawBytes, 0, this.bytes, 0, 64);
    }

    public Signature() {
    }

    @JsonValue
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public boolean equals(Object obj) {
        return obj instanceof Signature && Arrays.equals(this.bytes, ((Signature)obj).bytes);
    }
}

