/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Ed25519PublicKey;
import com.algorand.algosdk.crypto.MultisigAddress;
import com.algorand.algosdk.crypto.Signature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class MultisigSignature
implements Serializable {
    private static final String SIGN_ALGO = "EdDSA";
    private static final int MULTISIG_VERSION = 1;
    @JsonProperty(value="v")
    public int version;
    @JsonProperty(value="thr")
    public int threshold;
    @JsonProperty(value="subsig")
    public List<MultisigSubsig> subsigs = new ArrayList<MultisigSubsig>();

    @JsonCreator
    public MultisigSignature(@JsonProperty(value="v") int version, @JsonProperty(value="thr") int threshold, @JsonProperty(value="subsig") List<MultisigSubsig> subsigs) {
        this.version = version;
        this.threshold = threshold;
        this.subsigs = Objects.requireNonNull(subsigs, "subsigs must not be null");
    }

    public MultisigSignature(int version, int threshold) {
        this(version, threshold, new ArrayList<MultisigSubsig>());
    }

    public MultisigSignature() {
    }

    public boolean verify(byte[] message) {
        if (this.version != 1 || this.threshold <= 0 || this.subsigs.size() == 0) {
            return false;
        }
        if (this.threshold > this.subsigs.size()) {
            return false;
        }
        int verifiedCount = 0;
        Signature emptySig = new Signature();
        for (int i = 0; i < this.subsigs.size(); ++i) {
            MultisigSubsig subsig = this.subsigs.get(i);
            if (subsig.sig.equals(emptySig)) continue;
            try {
                PublicKey pk = new Address(subsig.key.getBytes()).toVerifyKey();
                java.security.Signature sig = java.security.Signature.getInstance(SIGN_ALGO);
                sig.initVerify(pk);
                sig.update(message);
                boolean verified = sig.verify(subsig.sig.getBytes());
                if (!verified) continue;
                ++verifiedCount;
                continue;
            }
            catch (Exception ex) {
                throw new IllegalStateException("verification of subsig " + i + "failed", ex);
            }
        }
        return verifiedCount >= this.threshold;
    }

    public MultisigAddress convertToMultisigAddress() {
        ArrayList<Ed25519PublicKey> pubK = new ArrayList<Ed25519PublicKey>();
        for (MultisigSubsig sig : this.subsigs) {
            pubK.add(sig.key);
        }
        return new MultisigAddress(this.version, this.threshold, pubK);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultisigSignature) {
            MultisigSignature actual = (MultisigSignature)obj;
            if (this.version != actual.version) {
                return false;
            }
            if (this.threshold != actual.threshold) {
                return false;
            }
            return this.subsigs.equals(actual.subsigs);
        }
        return false;
    }

    @JsonPropertyOrder(alphabetic=true)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class MultisigSubsig {
        @JsonProperty(value="pk")
        public Ed25519PublicKey key = new Ed25519PublicKey();
        @JsonProperty(value="s")
        public Signature sig = new Signature();

        @JsonCreator
        public MultisigSubsig(@JsonProperty(value="pk") byte[] key, @JsonProperty(value="s") byte[] sig) {
            if (key != null) {
                this.key = new Ed25519PublicKey(key);
            }
            if (sig != null) {
                this.sig = new Signature(sig);
            }
        }

        public MultisigSubsig(Ed25519PublicKey key, Signature sig) {
            this.key = Objects.requireNonNull(key, "public key cannot be null");
            this.sig = sig;
        }

        public MultisigSubsig(Ed25519PublicKey key) {
            this(key, new Signature());
        }

        public MultisigSubsig() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof MultisigSubsig) {
                MultisigSubsig actual = (MultisigSubsig)obj;
                return Arrays.equals(this.key.getBytes(), actual.key.getBytes()) && this.sig.equals(actual.sig);
            }
            return false;
        }
    }
}

