/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.algorand.algosdk.account.Account;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Ed25519PublicKey;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TxnSigner;
import com.algorand.algosdk.util.Digester;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(alphabetic=true)
public class MultisigAddress
implements Serializable {
    @JsonProperty(value="version")
    public final int version;
    @JsonProperty(value="threshold")
    public final int threshold;
    @JsonProperty(value="publicKeys")
    public final List<Ed25519PublicKey> publicKeys = new ArrayList<Ed25519PublicKey>();
    private static final byte[] PREFIX = "MultisigAddr".getBytes(StandardCharsets.UTF_8);

    public MultisigAddress(int version, int threshold, List<Ed25519PublicKey> publicKeys) {
        this.version = version;
        this.threshold = threshold;
        this.publicKeys.addAll(publicKeys);
        if (this.version != 1) {
            throw new IllegalArgumentException("Unknown msig version");
        }
        if (this.threshold == 0 || this.publicKeys.size() == 0 || this.threshold > this.publicKeys.size()) {
            throw new IllegalArgumentException("Invalid threshold");
        }
    }

    @JsonCreator
    private MultisigAddress(@JsonProperty(value="publicKeys") List<byte[]> publicKeys, @JsonProperty(value="version") int version, @JsonProperty(value="threshold") int threshold) {
        this(version, threshold, MultisigAddress.toKeys(publicKeys));
    }

    private static List<Ed25519PublicKey> toKeys(List<byte[]> keys) {
        ArrayList<Ed25519PublicKey> ret = new ArrayList<Ed25519PublicKey>();
        for (byte[] key : keys) {
            ret.add(new Ed25519PublicKey(key));
        }
        return ret;
    }

    public Address toAddress() throws NoSuchAlgorithmException {
        int numPkBytes = 32 * this.publicKeys.size();
        byte[] hashable = new byte[PREFIX.length + 2 + numPkBytes];
        System.arraycopy(PREFIX, 0, hashable, 0, PREFIX.length);
        hashable[MultisigAddress.PREFIX.length] = (byte)this.version;
        hashable[MultisigAddress.PREFIX.length + 1] = (byte)this.threshold;
        for (int i = 0; i < this.publicKeys.size(); ++i) {
            System.arraycopy(this.publicKeys.get(i).getBytes(), 0, hashable, PREFIX.length + 2 + i * 32, 32);
        }
        return new Address(Digester.digest(hashable));
    }

    public String toString() {
        try {
            return this.toAddress().toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigAddress that = (MultisigAddress)o;
        return this.version == that.version && this.threshold == that.threshold && this.publicKeys.equals(that.publicKeys);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.threshold, this.publicKeys);
    }

    public TxnSigner getTransactionSigner(final byte[][] sks) throws NoSuchAlgorithmException {
        final MultisigAddress self = this;
        final ArrayList<Account> msigAccounts = new ArrayList<Account>();
        for (byte[] sk : sks) {
            msigAccounts.add(new Account(sk));
        }
        return new TxnSigner(){

            public int hashCode() {
                return Objects.hash(3, self, Arrays.deepHashCode((Object[])sks));
            }

            private SignedTransaction signTxn(Transaction txn) throws NoSuchAlgorithmException {
                ArrayList<SignedTransaction> multiStxns = new ArrayList<SignedTransaction>();
                for (Account acc : msigAccounts) {
                    multiStxns.add(acc.signMultisigTransaction(self, txn));
                }
                return Account.mergeMultisigTransactions(multiStxns.toArray(new SignedTransaction[0]));
            }

            @Override
            public SignedTransaction[] signTxnGroup(Transaction[] txnGroup, int[] indicesToSign) throws NoSuchAlgorithmException {
                SignedTransaction[] sTxn = new SignedTransaction[indicesToSign.length];
                for (int i = 0; i < indicesToSign.length; ++i) {
                    sTxn[i] = this.signTxn(txnGroup[indicesToSign[i]]);
                }
                return sTxn;
            }
        };
    }
}

