/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class MerkleVerifier
implements Serializable {
    private static final int KEY_LEN_BYTES = 64;
    private byte[] bytes = new byte[64];

    @JsonCreator
    public MerkleVerifier(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        if (bytes.length != 64) {
            throw new IllegalArgumentException("state proof key wrong length");
        }
        System.arraycopy(bytes, 0, this.bytes, 0, 64);
    }

    public MerkleVerifier() {
    }

    @JsonValue
    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object obj) {
        return obj instanceof MerkleVerifier && Arrays.equals(this.bytes, ((MerkleVerifier)obj).bytes);
    }
}

