/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.MultisigSignature;
import com.algorand.algosdk.crypto.Signature;
import com.algorand.algosdk.util.Digester;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;

@JsonPropertyOrder(alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class LogicsigSignature {
    @JsonIgnore
    private static final byte[] LOGIC_PREFIX = "Program".getBytes(StandardCharsets.UTF_8);
    @JsonIgnore
    private static final String SIGN_ALGO = "EdDSA";
    @JsonProperty(value="l")
    public final byte[] logic;
    @JsonProperty(value="arg")
    public final List<byte[]> args;
    @JsonProperty(value="sig")
    public Signature sig;
    @JsonProperty(value="msig")
    public MultisigSignature msig;

    private static boolean isAsciiPrintable(byte symbol) {
        boolean isBreakLine = symbol == 10;
        boolean isStdPrintable = symbol >= 32 && symbol <= 126;
        return isBreakLine || isStdPrintable;
    }

    private static boolean isAsciiPrintable(byte[] program) {
        for (byte b : program) {
            if (LogicsigSignature.isAsciiPrintable(b)) continue;
            return false;
        }
        return true;
    }

    private static void sanityCheckProgram(byte[] program) {
        if (program == null || program.length == 0) {
            throw new IllegalArgumentException("empty program");
        }
        if (LogicsigSignature.isAsciiPrintable(program)) {
            boolean isAddress;
            block6: {
                isAddress = false;
                try {
                    new Address(new String(program));
                    isAddress = true;
                }
                catch (IllegalArgumentException | NoSuchAlgorithmException e) {
                    if (!(e instanceof NoSuchAlgorithmException)) break block6;
                    throw new IllegalArgumentException("cannot check if program bytes are Algorand address" + e);
                }
            }
            if (isAddress) {
                throw new IllegalArgumentException("requesting program bytes, get Algorand address");
            }
            if (Base64.isBase64((byte[])program)) {
                throw new IllegalArgumentException("program should not be b64 encoded");
            }
            throw new IllegalArgumentException("program bytes are all ASCII printable characters, not looking like Teal byte code");
        }
    }

    @JsonCreator
    public LogicsigSignature(@JsonProperty(value="l") byte[] logic, @JsonProperty(value="arg") List<byte[]> args, @JsonProperty(value="sig") byte[] sig, @JsonProperty(value="msig") MultisigSignature msig) {
        this.logic = Objects.requireNonNull(logic, "program must not be null");
        this.args = args;
        LogicsigSignature.sanityCheckProgram(this.logic);
        if (sig != null) {
            this.sig = new Signature(sig);
        }
        this.msig = msig;
    }

    public LogicsigSignature(byte[] logicsig) {
        this(logicsig, null);
    }

    public LogicsigSignature(byte[] logicsig, List<byte[]> args) {
        this(logicsig, args, null, null);
    }

    public LogicsigSignature() {
        this.logic = null;
        this.args = null;
    }

    public Address toAddress() throws NoSuchAlgorithmException {
        byte[] prefixedEncoded = this.bytesToSign();
        return new Address(Digester.digest(prefixedEncoded));
    }

    public byte[] bytesToSign() {
        byte[] prefixedEncoded = new byte[this.logic.length + LOGIC_PREFIX.length];
        System.arraycopy(LOGIC_PREFIX, 0, prefixedEncoded, 0, LOGIC_PREFIX.length);
        System.arraycopy(this.logic, 0, prefixedEncoded, LOGIC_PREFIX.length, this.logic.length);
        return prefixedEncoded;
    }

    public boolean verify(Address singleSigner) throws NoSuchAlgorithmException {
        PublicKey pk;
        if (this.logic == null) {
            return false;
        }
        if (this.sig != null && this.msig != null) {
            return false;
        }
        LogicsigSignature.sanityCheckProgram(this.logic);
        try {
            pk = singleSigner.toVerifyKey();
        }
        catch (Exception ex) {
            return false;
        }
        if (this.sig != null) {
            try {
                java.security.Signature sig = java.security.Signature.getInstance(SIGN_ALGO);
                sig.initVerify(pk);
                sig.update(this.bytesToSign());
                return sig.verify(this.sig.getBytes());
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (this.msig != null) {
            return this.msig.verify(this.bytesToSign());
        }
        return true;
    }

    private static boolean nullCheck(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null && o2 != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogicsigSignature) {
            LogicsigSignature actual = (LogicsigSignature)obj;
            if (!LogicsigSignature.nullCheck(this.logic, actual.logic)) {
                return false;
            }
            if (!Arrays.equals(this.logic, actual.logic)) {
                return false;
            }
            if (!LogicsigSignature.nullCheck(this.args, actual.args)) {
                return false;
            }
            if (this.args != null) {
                if (this.args.size() != actual.args.size()) {
                    return false;
                }
                for (int i = 0; i < this.args.size(); ++i) {
                    if (Arrays.equals(this.args.get(i), actual.args.get(i))) continue;
                    return false;
                }
            }
            if (!LogicsigSignature.nullCheck(this.sig, actual.sig)) {
                return false;
            }
            if (this.sig != null && !this.sig.equals(actual.sig)) {
                return false;
            }
            if (!LogicsigSignature.nullCheck(this.msig, actual.msig)) {
                return false;
            }
            return this.msig == null || this.msig.equals(actual.msig);
        }
        return false;
    }
}

