/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Ed25519PublicKey
implements Serializable {
    public static final int KEY_LEN_BYTES = 32;
    private final byte[] bytes = new byte[32];

    @JsonCreator
    public Ed25519PublicKey(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        if (bytes.length != 32) {
            throw new IllegalArgumentException("ed25519 public key wrong length");
        }
        System.arraycopy(bytes, 0, this.bytes, 0, 32);
    }

    public Ed25519PublicKey() {
    }

    @JsonValue
    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object obj) {
        return obj instanceof Ed25519PublicKey && Arrays.equals(this.bytes, ((Ed25519PublicKey)obj).bytes);
    }
}

