/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.algorand.algosdk.util.Encoder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Digest
implements Serializable {
    private static final int DIG_LEN_BYTES = 32;
    private final byte[] bytes = new byte[32];

    @JsonCreator
    public Digest(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        if (bytes.length != 32) {
            throw new IllegalArgumentException("digest wrong length");
        }
        System.arraycopy(bytes, 0, this.bytes, 0, 32);
    }

    @JsonIgnore
    public Digest(String base32StringDigest) {
        this(Encoder.decodeFromBase32StripPad(base32StringDigest));
    }

    public String toString() {
        return Encoder.encodeToBase32StripPad(this.bytes);
    }

    public Digest() {
    }

    @JsonValue
    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object obj) {
        return obj instanceof Digest && Arrays.equals(this.bytes, ((Digest)obj).bytes);
    }
}

