/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.crypto;

import com.algorand.algosdk.crypto.Signature;
import com.algorand.algosdk.util.CryptoProvider;
import com.algorand.algosdk.util.Digester;
import com.algorand.algosdk.util.Encoder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.codec.binary.Base32;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Address
implements Serializable {
    public static final int LEN_BYTES = 32;
    private final byte[] bytes = new byte[32];
    private static final int CHECKSUM_LEN_BYTES = 4;
    private static final int EXPECTED_STR_ENCODED_LEN = 58;
    private static final String SIGN_ALGO = "EdDSA";
    private static final String KEY_ALGO = "Ed25519";
    private static final byte[] BYTES_SIGN_PREFIX = "MX".getBytes(StandardCharsets.UTF_8);
    public static final byte[] APP_ID_PREFIX = "appID".getBytes(StandardCharsets.UTF_8);

    @JsonCreator
    public Address(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        if (bytes.length != 32) {
            throw new IllegalArgumentException(String.format("Given address length is not %s", 32));
        }
        System.arraycopy(bytes, 0, this.bytes, 0, 32);
    }

    public Address() {
    }

    @JsonValue
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public Address(String encodedAddr) throws NoSuchAlgorithmException {
        byte[] addr;
        byte[] hashedAddr;
        byte[] expectedChecksum;
        Objects.requireNonNull(encodedAddr, "address must not be null");
        Base32 codec = new Base32();
        byte[] checksumAddr = codec.decode(encodedAddr);
        if (checksumAddr.length != 36) {
            throw new IllegalArgumentException("Input string is an invalid address. Wrong length");
        }
        byte[] checksum = Arrays.copyOfRange(checksumAddr, 32, checksumAddr.length);
        if (!Arrays.equals(checksum, expectedChecksum = Arrays.copyOfRange(hashedAddr = Digester.digest(Arrays.copyOf(addr = Arrays.copyOf(checksumAddr, 32), 32)), 28, hashedAddr.length))) {
            throw new IllegalArgumentException("Input checksum did not validate");
        }
        System.arraycopy(addr, 0, this.bytes, 0, 32);
    }

    public String encodeAsString() throws NoSuchAlgorithmException {
        byte[] hashedAddr = Digester.digest(Arrays.copyOf(this.bytes, 32));
        byte[] checksum = Arrays.copyOfRange(hashedAddr, 28, hashedAddr.length);
        byte[] checksumAddr = Arrays.copyOf(this.bytes, this.bytes.length + 4);
        System.arraycopy(checksum, 0, checksumAddr, this.bytes.length, 4);
        String res = Encoder.encodeToBase32StripPad(checksumAddr);
        if (res.length() != 58) {
            throw new RuntimeException("unexpected address length " + res.length());
        }
        return res;
    }

    public boolean verifyBytes(byte[] message, Signature signature) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        PublicKey pk = this.toVerifyKey();
        byte[] prefixBytes = new byte[message.length + BYTES_SIGN_PREFIX.length];
        System.arraycopy(BYTES_SIGN_PREFIX, 0, prefixBytes, 0, BYTES_SIGN_PREFIX.length);
        System.arraycopy(message, 0, prefixBytes, BYTES_SIGN_PREFIX.length, message.length);
        java.security.Signature sig = java.security.Signature.getInstance(SIGN_ALGO);
        sig.initVerify(pk);
        sig.update(prefixBytes);
        return sig.verify(signature.getBytes());
    }

    public PublicKey toVerifyKey() throws InvalidKeySpecException, NoSuchAlgorithmException {
        X509EncodedKeySpec pkS;
        CryptoProvider.setupIfNeeded();
        try {
            SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), this.bytes);
            pkS = new X509EncodedKeySpec(publicKeyInfo.getEncoded());
        }
        catch (IOException e) {
            throw new RuntimeException("could not parse raw key bytes", e);
        }
        KeyFactory kf = KeyFactory.getInstance(KEY_ALGO);
        PublicKey pk = kf.generatePublic(pkS);
        return pk;
    }

    public String toString() {
        try {
            return this.encodeAsString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Address && Arrays.equals(this.bytes, ((Address)obj).bytes);
    }

    public boolean compareTo(String address) {
        if (this.equals(new Address())) {
            return address.isEmpty();
        }
        return this.toString().equals(address);
    }

    public static Address forApplication(long appID) throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(APP_ID_PREFIX);
        buffer.write(Encoder.encodeUint64(appID));
        return new Address(Digester.digest(buffer.toByteArray()));
    }
}

