/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.algod.client.ApiException;
import com.algorand.algosdk.algod.client.api.AlgodApi;
import com.algorand.algosdk.algod.client.model.TransactionParams;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.transaction.Lease;
import com.algorand.algosdk.util.Encoder;
import com.algorand.algosdk.v2.client.common.AlgodClient;
import com.algorand.algosdk.v2.client.common.Response;
import com.algorand.algosdk.v2.client.model.TransactionParametersResponse;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;

public abstract class TransactionParametersBuilder<T extends TransactionParametersBuilder<T>> {
    protected Address sender = null;
    protected BigInteger fee = null;
    protected BigInteger flatFee = null;
    protected BigInteger firstValid = null;
    protected BigInteger lastValid = null;
    protected byte[] note = null;
    protected byte[] lease = null;
    protected Address rekeyTo = null;
    protected String genesisID = null;
    protected Digest genesisHash = null;

    public T lookupParams(AlgodApi client) throws ApiException {
        TransactionParams params = client.transactionParams();
        return this.suggestedParams(params);
    }

    public T suggestedParams(TransactionParams params) {
        if (this.fee == null) {
            this.fee(params.getFee());
        }
        if (this.genesisID == null) {
            this.genesisID(params.getGenesisID());
        }
        if (this.genesisHash == null) {
            this.genesisHash(params.getGenesishashb64());
        }
        if (this.firstValid == null) {
            this.firstValid(params.getLastRound());
        }
        if (this.lastValid == null) {
            this.lastValid(params.getLastRound().add(BigInteger.valueOf(1000L)));
        }
        return (T)this;
    }

    public T lookupParams(AlgodClient client) throws Exception {
        Response<TransactionParametersResponse> params = client.TransactionParams().execute();
        return this.suggestedParams(params.body());
    }

    public T suggestedParams(TransactionParametersResponse params) {
        this.fee(params.fee);
        this.genesisID(params.genesisId);
        this.genesisHash(params.genesisHash);
        this.firstValid(params.lastRound);
        this.lastValid(params.lastRound + 1000L);
        return (T)this;
    }

    public T sender(Address sender) {
        this.sender = sender;
        return (T)this;
    }

    public T sender(String sender) {
        try {
            this.sender = new Address(sender);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T sender(byte[] sender) {
        this.sender = new Address(sender);
        return (T)this;
    }

    public T fee(BigInteger fee) {
        this.fee = fee;
        return (T)this;
    }

    public T fee(Integer fee) {
        if (fee < 0) {
            throw new IllegalArgumentException("fee cannot be a negative value");
        }
        this.fee = BigInteger.valueOf(fee.intValue());
        return (T)this;
    }

    public T fee(Long fee) {
        if (fee < 0L) {
            throw new IllegalArgumentException("fee cannot be a negative value");
        }
        this.fee = BigInteger.valueOf(fee);
        return (T)this;
    }

    public T flatFee(BigInteger flatFee) {
        this.flatFee = flatFee;
        return (T)this;
    }

    public T flatFee(Integer flatFee) {
        if (flatFee < 0) {
            throw new IllegalArgumentException("flatFee cannot be a negative value");
        }
        this.flatFee = BigInteger.valueOf(flatFee.intValue());
        return (T)this;
    }

    public T flatFee(Long flatFee) {
        if (flatFee < 0L) {
            throw new IllegalArgumentException("flatFee cannot be a negative value");
        }
        this.flatFee = BigInteger.valueOf(flatFee);
        return (T)this;
    }

    public T firstValid(BigInteger firstValid) {
        this.firstValid = firstValid;
        return (T)this;
    }

    public T firstValid(Integer firstValid) {
        if (firstValid < 0) {
            throw new IllegalArgumentException("firstValid cannot be a negative value");
        }
        this.firstValid = BigInteger.valueOf(firstValid.intValue());
        return (T)this;
    }

    public T firstValid(Long firstValid) {
        if (firstValid < 0L) {
            throw new IllegalArgumentException("firstValid cannot be a negative value");
        }
        this.firstValid = BigInteger.valueOf(firstValid);
        return (T)this;
    }

    public T lastValid(BigInteger lastValid) {
        this.lastValid = lastValid;
        return (T)this;
    }

    public T lastValid(Integer lastValid) {
        if (lastValid < 0) {
            throw new IllegalArgumentException("lastValid cannot be a negative value");
        }
        this.lastValid = BigInteger.valueOf(lastValid.intValue());
        return (T)this;
    }

    public T lastValid(Long lastValid) {
        if (lastValid < 0L) {
            throw new IllegalArgumentException("lastValid cannot be a negative value");
        }
        this.lastValid = BigInteger.valueOf(lastValid);
        return (T)this;
    }

    public T note(byte[] note) {
        this.note = note;
        return (T)this;
    }

    public T noteUTF8(String note) {
        this.note = note.getBytes(StandardCharsets.UTF_8);
        return (T)this;
    }

    public T noteB64(String note) {
        this.note = Encoder.decodeFromBase64(note);
        return (T)this;
    }

    public T lease(Lease lease) {
        this.lease = lease.getBytes();
        return (T)this;
    }

    public T lease(byte[] lease) {
        this.lease = lease;
        return (T)this;
    }

    public T leaseUTF8(String lease) {
        this.lease = lease.getBytes(StandardCharsets.UTF_8);
        return (T)this;
    }

    public T leaseB64(String lease) {
        this.lease = Encoder.decodeFromBase64(lease);
        return (T)this;
    }

    public T rekey(Address rekeyTo) {
        this.rekeyTo = rekeyTo;
        return (T)this;
    }

    public T rekey(String rekeyTo) {
        try {
            this.rekeyTo = new Address(rekeyTo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T rekey(byte[] rekeyTo) {
        this.rekeyTo = new Address(rekeyTo);
        return (T)this;
    }

    public T genesisID(String genesisID) {
        this.genesisID = genesisID;
        return (T)this;
    }

    public T genesisHash(Digest genesisHash) {
        this.genesisHash = genesisHash;
        return (T)this;
    }

    public T genesisHash(byte[] genesisHash) {
        this.genesisHash = new Digest(genesisHash);
        return (T)this;
    }

    public T genesisHashUTF8(String genesisHash) {
        this.genesisHash = new Digest(genesisHash.getBytes(StandardCharsets.UTF_8));
        return (T)this;
    }

    public T genesisHashB64(String genesisHash) {
        this.genesisHash = new Digest(Encoder.decodeFromBase64(genesisHash));
        return (T)this;
    }
}

