/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.account.Account;
import com.algorand.algosdk.builder.transaction.TransactionParametersBuilder;
import com.algorand.algosdk.crypto.Digest;
import com.algorand.algosdk.transaction.Lease;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.Encoder;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;

public abstract class TransactionBuilder<T extends TransactionBuilder<T>>
extends TransactionParametersBuilder<T> {
    protected final Transaction.Type type;
    protected Digest group = null;

    protected TransactionBuilder(Transaction.Type type) {
        this.type = type;
    }

    protected abstract void applyTo(Transaction var1);

    public final Transaction build() {
        if (this.lastValid == null && this.firstValid != null) {
            this.lastValid = this.firstValid.add(BigInteger.valueOf(1000L));
        }
        Transaction txn = new Transaction();
        txn.type = this.type;
        this.applyTo(txn);
        if (this.sender != null) {
            txn.sender = this.sender;
        }
        if (this.firstValid != null) {
            txn.firstValid = this.firstValid;
        }
        if (this.lastValid != null) {
            txn.lastValid = this.lastValid;
        }
        if (this.note != null && this.note.length > 0) {
            txn.note = this.note;
        }
        if (this.rekeyTo != null) {
            txn.rekeyTo = this.rekeyTo;
        }
        if (this.genesisID != null) {
            txn.genesisID = this.genesisID;
        }
        if (this.genesisHash != null) {
            txn.genesisHash = this.genesisHash;
        }
        if (this.lease != null && this.lease.length != 0) {
            txn.setLease(new Lease(this.lease));
        }
        if (this.fee != null && this.flatFee != null) {
            throw new IllegalArgumentException("Cannot set both fee and flatFee.");
        }
        if (this.fee == null && this.flatFee == null) {
            txn.fee = Account.MIN_TX_FEE_UALGOS;
            return txn;
        }
        if (this.fee != null) {
            try {
                Account.setFeeByFeePerByte(txn, this.fee);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException(e);
            }
            if (txn.fee == null || txn.fee.equals(BigInteger.valueOf(0L))) {
                txn.fee = Account.MIN_TX_FEE_UALGOS;
            }
        }
        if (this.flatFee != null) {
            txn.fee = this.flatFee;
        }
        return txn;
    }

    public T group(Digest group) {
        this.group = group;
        return (T)this;
    }

    public T group(byte[] group) {
        this.group = new Digest(group);
        return (T)this;
    }

    public T groupUTF8(String group) {
        this.group = new Digest(group.getBytes(StandardCharsets.UTF_8));
        return (T)this;
    }

    public T groupB64(String group) {
        this.group = new Digest(Encoder.decodeFromBase64(group));
        return (T)this;
    }
}

