/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.transaction.Transaction;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class PaymentTransactionBuilder<T extends PaymentTransactionBuilder<T>>
extends TransactionBuilder<T> {
    protected BigInteger amount = null;
    protected Address receiver = null;
    protected Address closeRemainderTo = null;

    public static PaymentTransactionBuilder<?> Builder() {
        return new PaymentTransactionBuilder();
    }

    protected PaymentTransactionBuilder() {
        super(Transaction.Type.Payment);
    }

    @Override
    protected void applyTo(Transaction txn) {
        if (this.sender == null && this.closeRemainderTo == null) {
            throw new IllegalArgumentException("Must set at least one of 'receiver' or 'closeRemainderTo'");
        }
        Objects.requireNonNull(this.sender, "sender is required.");
        Objects.requireNonNull(this.firstValid, "firstValid is required.");
        Objects.requireNonNull(this.lastValid, "lastValid is required.");
        Objects.requireNonNull(this.genesisHash, "genesisHash is required.");
        if (this.amount != null) {
            txn.amount = this.amount;
        }
        if (this.receiver != null) {
            txn.receiver = this.receiver;
        }
        if (this.closeRemainderTo != null) {
            txn.closeRemainderTo = this.closeRemainderTo;
        }
    }

    public T amount(BigInteger amount) {
        this.amount = amount;
        return (T)this;
    }

    public T amount(Integer amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("amount cannot be a negative value");
        }
        this.amount = BigInteger.valueOf(amount.intValue());
        return (T)this;
    }

    public T amount(Long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("amount cannot be a negative value");
        }
        this.amount = BigInteger.valueOf(amount);
        return (T)this;
    }

    public T receiver(Address receiver) {
        this.receiver = receiver;
        return (T)this;
    }

    public T receiver(String receiver) {
        try {
            this.receiver = new Address(receiver);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T receiver(byte[] receiver) {
        this.receiver = new Address(receiver);
        return (T)this;
    }

    public T closeRemainderTo(Address closeRemainderTo) {
        this.closeRemainderTo = closeRemainderTo;
        return (T)this;
    }

    public T closeRemainderTo(String closeRemainderTo) {
        try {
            this.closeRemainderTo = new Address(closeRemainderTo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T closeRemainderTo(byte[] closeRemainderTo) {
        this.closeRemainderTo = new Address(closeRemainderTo);
        return (T)this;
    }
}

