/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.abi.Method;
import com.algorand.algosdk.builder.transaction.ApplicationCallReferencesSetter;
import com.algorand.algosdk.builder.transaction.StateSchemaSetter;
import com.algorand.algosdk.builder.transaction.TEALProgramSetter;
import com.algorand.algosdk.builder.transaction.TransactionParametersBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.TEALProgram;
import com.algorand.algosdk.logic.StateSchema;
import com.algorand.algosdk.transaction.MethodCallParams;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TxnSigner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MethodCallTransactionBuilder<T extends MethodCallTransactionBuilder<T>>
extends TransactionParametersBuilder<T>
implements StateSchemaSetter<T>,
TEALProgramSetter<T>,
ApplicationCallReferencesSetter<T> {
    protected Long appID;
    protected Transaction.OnCompletion onCompletion;
    protected Method method;
    protected List<Object> methodArgs = new ArrayList<Object>();
    protected List<Address> foreignAccounts = new ArrayList<Address>();
    protected List<Long> foreignAssets = new ArrayList<Long>();
    protected List<Long> foreignApps = new ArrayList<Long>();
    protected TEALProgram approvalProgram;
    protected TEALProgram clearStateProgram;
    protected StateSchema localStateSchema;
    protected StateSchema globalStateSchema;
    protected Long extraPages;
    protected TxnSigner signer;

    public static MethodCallTransactionBuilder<?> Builder() {
        return new MethodCallTransactionBuilder();
    }

    @Override
    public T applicationId(Long applicationId) {
        this.appID = applicationId;
        return (T)this;
    }

    public T onComplete(Transaction.OnCompletion op) {
        this.onCompletion = op;
        return (T)this;
    }

    public T method(Method method) {
        this.method = method;
        return (T)this;
    }

    public T methodArguments(List<Object> arguments) {
        this.methodArgs = new ArrayList<Object>(arguments);
        return (T)this;
    }

    public T addMethodArguments(List<Object> arguments) {
        this.methodArgs.addAll(arguments);
        return (T)this;
    }

    public T addMethodArgument(Object argument) {
        this.methodArgs.add(argument);
        return (T)this;
    }

    public T signer(TxnSigner signer) {
        this.signer = signer;
        return (T)this;
    }

    @Override
    public T accounts(List<Address> accounts) {
        if (accounts != null) {
            this.foreignAccounts = new ArrayList<Address>(new HashSet<Address>(accounts));
        } else {
            this.foreignAccounts.clear();
        }
        return (T)this;
    }

    @Override
    public T foreignApps(List<Long> foreignApps) {
        if (foreignApps != null) {
            this.foreignApps = new ArrayList<Long>(new HashSet<Long>(foreignApps));
        } else {
            this.foreignApps.clear();
        }
        return (T)this;
    }

    @Override
    public T foreignAssets(List<Long> foreignAssets) {
        if (foreignAssets != null) {
            this.foreignAssets = new ArrayList<Long>(new HashSet<Long>(foreignAssets));
        } else {
            this.foreignAssets.clear();
        }
        return (T)this;
    }

    @Override
    public T approvalProgram(TEALProgram approvalProgram) {
        this.approvalProgram = approvalProgram;
        return (T)this;
    }

    @Override
    public T clearStateProgram(TEALProgram clearStateProgram) {
        this.clearStateProgram = clearStateProgram;
        return (T)this;
    }

    @Override
    public T localStateSchema(StateSchema localStateSchema) {
        this.localStateSchema = localStateSchema;
        return (T)this;
    }

    @Override
    public T globalStateSchema(StateSchema globalStateSchema) {
        this.globalStateSchema = globalStateSchema;
        return (T)this;
    }

    @Override
    public T extraPages(Long extraPages) {
        if (extraPages == null || extraPages < 0L || extraPages > 3L) {
            throw new IllegalArgumentException("extraPages must be an integer between 0 and 3 inclusive");
        }
        this.extraPages = extraPages;
        return (T)this;
    }

    public MethodCallParams build() {
        return new MethodCallParams(this.appID, this.method, this.methodArgs, this.sender, this.onCompletion, this.note, this.lease, this.genesisID, this.genesisHash, this.firstValid, this.lastValid, this.fee, this.flatFee, this.rekeyTo, this.signer, this.foreignAccounts, this.foreignAssets, this.foreignApps, this.approvalProgram, this.clearStateProgram, this.globalStateSchema, this.localStateSchema, this.extraPages);
    }
}

