/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.crypto.MerkleVerifier;
import com.algorand.algosdk.crypto.ParticipationPublicKey;
import com.algorand.algosdk.crypto.VRFPublicKey;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.Encoder;
import java.math.BigInteger;
import java.util.Objects;

public class KeyRegistrationTransactionBuilder<T extends KeyRegistrationTransactionBuilder<T>>
extends TransactionBuilder<T> {
    protected boolean nonparticipation = false;
    protected ParticipationPublicKey votePK = new ParticipationPublicKey();
    protected VRFPublicKey selectionPK = new VRFPublicKey();
    protected BigInteger voteFirst = BigInteger.valueOf(0L);
    protected BigInteger voteLast = BigInteger.valueOf(0L);
    protected BigInteger voteKeyDilution = BigInteger.valueOf(0L);
    protected MerkleVerifier stateProofPk = new MerkleVerifier();

    public static KeyRegistrationTransactionBuilder<?> Builder() {
        return new KeyRegistrationTransactionBuilder();
    }

    protected KeyRegistrationTransactionBuilder() {
        super(Transaction.Type.KeyRegistration);
    }

    @Override
    protected void applyTo(Transaction txn) {
        Objects.requireNonNull(this.sender, "sender is required");
        Objects.requireNonNull(this.firstValid, "firstValid is required");
        Objects.requireNonNull(this.lastValid, "lastValid is required");
        Objects.requireNonNull(this.genesisHash, "genesisHash is required");
        if (this.votePK != null) {
            txn.votePK = this.votePK;
        }
        if (this.selectionPK != null) {
            txn.selectionPK = this.selectionPK;
        }
        if (this.voteFirst != null) {
            txn.voteFirst = this.voteFirst;
        }
        if (this.voteLast != null) {
            txn.voteLast = this.voteLast;
        }
        if (this.voteKeyDilution != null) {
            txn.voteKeyDilution = this.voteKeyDilution;
        }
        if (this.stateProofPk != null) {
            txn.stateProofKey = this.stateProofPk;
        }
        txn.nonpart = this.nonparticipation;
    }

    public T participationPublicKey(ParticipationPublicKey pk) {
        this.votePK = pk;
        return (T)this;
    }

    public T participationPublicKey(byte[] pk) {
        this.votePK = new ParticipationPublicKey(pk);
        return (T)this;
    }

    public T participationPublicKeyBase64(String pk) {
        this.votePK = new ParticipationPublicKey(Encoder.decodeFromBase64(pk));
        return (T)this;
    }

    public T selectionPublicKey(VRFPublicKey pk) {
        this.selectionPK = pk;
        return (T)this;
    }

    public T selectionPublicKey(byte[] pk) {
        this.selectionPK = new VRFPublicKey(pk);
        return (T)this;
    }

    public T selectionPublicKeyBase64(String pk) {
        this.selectionPK = new VRFPublicKey(Encoder.decodeFromBase64(pk));
        return (T)this;
    }

    public T voteFirst(BigInteger voteFirst) {
        this.voteFirst = voteFirst;
        return (T)this;
    }

    public T voteFirst(Integer voteFirst) {
        if (voteFirst < 0) {
            throw new IllegalArgumentException("voteFirst cannot be a negative value");
        }
        this.voteFirst = BigInteger.valueOf(voteFirst.intValue());
        return (T)this;
    }

    public T voteFirst(Long voteFirst) {
        if (voteFirst < 0L) {
            throw new IllegalArgumentException("voteFirst cannot be a negative value");
        }
        this.voteFirst = BigInteger.valueOf(voteFirst);
        return (T)this;
    }

    public T voteLast(BigInteger voteLast) {
        this.voteLast = voteLast;
        return (T)this;
    }

    public T voteLast(Integer voteLast) {
        if (voteLast < 0) {
            throw new IllegalArgumentException("voteLast cannot be a negative value");
        }
        this.voteLast = BigInteger.valueOf(voteLast.intValue());
        return (T)this;
    }

    public T voteLast(Long voteLast) {
        if (voteLast < 0L) {
            throw new IllegalArgumentException("voteLast cannot be a negative value");
        }
        this.voteLast = BigInteger.valueOf(voteLast);
        return (T)this;
    }

    public T voteKeyDilution(BigInteger voteKeyDilution) {
        this.voteKeyDilution = voteKeyDilution;
        return (T)this;
    }

    public T voteKeyDilution(Integer voteKeyDilution) {
        if (voteKeyDilution < 0) {
            throw new IllegalArgumentException("voteKeyDilution cannot be a negative value");
        }
        this.voteKeyDilution = BigInteger.valueOf(voteKeyDilution.intValue());
        return (T)this;
    }

    public T voteKeyDilution(Long voteKeyDilution) {
        if (voteKeyDilution < 0L) {
            throw new IllegalArgumentException("voteKeyDilution cannot be a negative value");
        }
        this.voteKeyDilution = BigInteger.valueOf(voteKeyDilution);
        return (T)this;
    }

    public T stateProofKey(MerkleVerifier stprf) {
        this.stateProofPk = stprf;
        return (T)this;
    }

    public T stateProofKey(byte[] stprf) {
        this.stateProofPk = new MerkleVerifier(stprf);
        return (T)this;
    }

    public T stateProofKeyBase64(String stprf) {
        this.stateProofPk = new MerkleVerifier(Encoder.decodeFromBase64(stprf));
        return (T)this;
    }

    public T nonparticipation(boolean nonpart) {
        this.nonparticipation = nonpart;
        return (T)this;
    }
}

