/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.transaction.Transaction;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class AssetFreezeTransactionBuilder<T extends AssetFreezeTransactionBuilder<T>>
extends TransactionBuilder<T> {
    protected Address freezeTarget = null;
    protected BigInteger assetIndex = null;
    protected boolean freezeState = false;

    public static AssetFreezeTransactionBuilder<?> Builder() {
        return new AssetFreezeTransactionBuilder();
    }

    protected AssetFreezeTransactionBuilder() {
        super(Transaction.Type.AssetFreeze);
    }

    @Override
    protected void applyTo(Transaction txn) {
        Objects.requireNonNull(this.assetIndex, "assetIndex is required.");
        Objects.requireNonNull(Boolean.valueOf(this.freezeState), "freezeState is required.");
        if (this.freezeTarget != null) {
            txn.freezeTarget = this.freezeTarget;
        }
        if (this.assetIndex != null) {
            txn.assetFreezeID = this.assetIndex;
        }
        txn.freezeState = this.freezeState;
    }

    public T freezeTarget(Address freezeTarget) {
        this.freezeTarget = freezeTarget;
        return (T)this;
    }

    public T freezeTarget(String freezeTarget) {
        try {
            this.freezeTarget = new Address(freezeTarget);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T freezeTarget(byte[] freezeTarget) {
        this.freezeTarget = new Address(freezeTarget);
        return (T)this;
    }

    public T assetIndex(BigInteger assetIndex) {
        this.assetIndex = assetIndex;
        return (T)this;
    }

    public T assetIndex(Integer assetIndex) {
        if (assetIndex < 0) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex.intValue());
        return (T)this;
    }

    public T assetIndex(Long assetIndex) {
        if (assetIndex < 0L) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex);
        return (T)this;
    }

    public T freezeState(boolean freezeState) {
        this.freezeState = freezeState;
        return (T)this;
    }
}

