/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.transaction.Transaction;
import java.math.BigInteger;
import java.util.Objects;

public class AssetDestroyTransactionBuilder<T extends AssetDestroyTransactionBuilder<T>>
extends TransactionBuilder<T> {
    protected BigInteger assetIndex = null;

    public static AssetDestroyTransactionBuilder<?> Builder() {
        return new AssetDestroyTransactionBuilder();
    }

    protected AssetDestroyTransactionBuilder() {
        super(Transaction.Type.AssetConfig);
    }

    @Override
    protected void applyTo(Transaction txn) {
        Objects.requireNonNull(this.assetIndex, "assetIndex is required.");
        if (this.assetIndex != null) {
            txn.assetIndex = this.assetIndex;
        }
    }

    public T assetIndex(BigInteger assetIndex) {
        this.assetIndex = assetIndex;
        return (T)this;
    }

    public T assetIndex(Integer assetIndex) {
        if (assetIndex < 0) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex.intValue());
        return (T)this;
    }

    public T assetIndex(Long assetIndex) {
        if (assetIndex < 0L) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex);
        return (T)this;
    }
}

