/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.transaction.AssetParams;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.Encoder;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class AssetCreateTransactionBuilder<T extends AssetCreateTransactionBuilder<T>>
extends TransactionBuilder<T> {
    protected BigInteger assetTotal = null;
    protected Integer assetDecimals = null;
    protected boolean defaultFrozen = false;
    protected String assetUnitName = null;
    protected String assetName = null;
    protected String url = null;
    protected byte[] metadataHash = null;
    protected Address manager = null;
    protected Address reserve = null;
    protected Address freeze = null;
    protected Address clawback = null;

    public static AssetCreateTransactionBuilder<?> Builder() {
        return new AssetCreateTransactionBuilder();
    }

    private AssetCreateTransactionBuilder() {
        super(Transaction.Type.AssetConfig);
    }

    protected AssetCreateTransactionBuilder(Transaction.Type type) {
        super(type);
    }

    @Override
    protected void applyTo(Transaction txn) {
        AssetParams params;
        if (this.getClass() == AssetCreateTransactionBuilder.class) {
            Objects.requireNonNull(this.sender, "sender is required.");
            Objects.requireNonNull(this.firstValid, "firstValid is required.");
            Objects.requireNonNull(this.lastValid, "lastValid is required.");
            Objects.requireNonNull(this.genesisHash, "genesisHash is required.");
            Objects.requireNonNull(this.assetTotal, "assetTotal is required.");
            Objects.requireNonNull(this.assetDecimals, "assetDecimals is required.");
        }
        txn.assetParams = params = new AssetParams(this.assetTotal, this.assetDecimals, this.defaultFrozen, this.assetUnitName, this.assetName, this.url, this.metadataHash, this.manager, this.reserve, this.freeze, this.clawback);
    }

    public T assetTotal(BigInteger assetTotal) {
        this.assetTotal = assetTotal;
        return (T)this;
    }

    public T assetTotal(Integer assetTotal) {
        if (assetTotal < 0) {
            throw new IllegalArgumentException("assetTotal cannot be a negative value");
        }
        this.assetTotal = BigInteger.valueOf(assetTotal.intValue());
        return (T)this;
    }

    public T assetTotal(Long assetTotal) {
        if (assetTotal < 0L) {
            throw new IllegalArgumentException("assetTotal cannot be a negative value");
        }
        this.assetTotal = BigInteger.valueOf(assetTotal);
        return (T)this;
    }

    public T assetDecimals(int assetDecimals) {
        this.assetDecimals = assetDecimals;
        return (T)this;
    }

    public T defaultFrozen(boolean defaultFrozen) {
        this.defaultFrozen = defaultFrozen;
        return (T)this;
    }

    public T assetUnitName(String assetUnitName) {
        this.assetUnitName = assetUnitName;
        return (T)this;
    }

    public T assetName(String assetName) {
        this.assetName = assetName;
        return (T)this;
    }

    public T url(String url) {
        if (url != null && url.length() > 96) {
            throw new IllegalArgumentException("url length must be between 0 and 96 characters (inclusive).");
        }
        this.url = url;
        return (T)this;
    }

    public T metadataHash(byte[] metadataHash) {
        this.metadataHash = metadataHash;
        return (T)this;
    }

    public T metadataHashUTF8(String metadataHash) {
        this.metadataHash = metadataHash.getBytes(StandardCharsets.UTF_8);
        return (T)this;
    }

    public T metadataHashB64(String metadataHash) {
        this.metadataHash = Encoder.decodeFromBase64(metadataHash);
        return (T)this;
    }

    public T manager(Address manager) {
        this.manager = manager;
        return (T)this;
    }

    public T manager(String manager) {
        try {
            this.manager = new Address(manager);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T manager(byte[] manager) {
        this.manager = new Address(manager);
        return (T)this;
    }

    public T reserve(Address reserve) {
        this.reserve = reserve;
        return (T)this;
    }

    public T reserve(String reserve) {
        try {
            this.reserve = new Address(reserve);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T reserve(byte[] reserve) {
        this.reserve = new Address(reserve);
        return (T)this;
    }

    public T freeze(Address freeze) {
        this.freeze = freeze;
        return (T)this;
    }

    public T freeze(String freeze) {
        try {
            this.freeze = new Address(freeze);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T freeze(byte[] freeze) {
        this.freeze = new Address(freeze);
        return (T)this;
    }

    public T clawback(Address clawback) {
        this.clawback = clawback;
        return (T)this;
    }

    public T clawback(String clawback) {
        try {
            this.clawback = new Address(clawback);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T clawback(byte[] clawback) {
        this.clawback = new Address(clawback);
        return (T)this;
    }
}

