/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.AssetCreateTransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.transaction.Transaction;
import java.math.BigInteger;

public class AssetConfigureTransactionBuilder<T extends AssetConfigureTransactionBuilder<T>>
extends AssetCreateTransactionBuilder<T> {
    protected BigInteger assetIndex = null;
    protected boolean strictEmptyAddressChecking = true;

    public static AssetConfigureTransactionBuilder<?> Builder() {
        return new AssetConfigureTransactionBuilder();
    }

    private AssetConfigureTransactionBuilder() {
        super(Transaction.Type.AssetConfig);
    }

    @Override
    protected void applyTo(Transaction txn) {
        if (this.assetUnitName != null) {
            throw new IllegalArgumentException("Must not set assetUnitName.");
        }
        if (this.assetName != null) {
            throw new IllegalArgumentException("Must not set assetName.");
        }
        if (this.url != null) {
            throw new IllegalArgumentException("Must not set url.");
        }
        if (this.metadataHash != null) {
            throw new IllegalArgumentException("Must not set metadataHash.");
        }
        if (this.assetDecimals != null) {
            throw new IllegalArgumentException("Must not set assetDecimals.");
        }
        if (this.assetTotal != null) {
            throw new IllegalArgumentException("Must not set assetTotal.");
        }
        if (this.defaultFrozen) {
            throw new IllegalArgumentException("Must not set defaultFrozen.");
        }
        Address defaultAddr = new Address();
        if (this.strictEmptyAddressChecking && (this.manager == null || this.manager.equals(defaultAddr) || this.reserve == null || this.reserve.equals(defaultAddr) || this.freeze == null || this.freeze.equals(defaultAddr) || this.clawback == null || this.clawback.equals(defaultAddr))) {
            throw new RuntimeException("strict empty address checking requested but empty or default address supplied to one or more manager addresses");
        }
        if (this.assetIndex != null) {
            txn.assetIndex = this.assetIndex;
        }
        super.applyTo(txn);
    }

    public T assetIndex(BigInteger assetIndex) {
        this.assetIndex = assetIndex;
        return (T)this;
    }

    public T assetIndex(Integer assetIndex) {
        if (assetIndex < 0) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex.intValue());
        return (T)this;
    }

    public T assetIndex(Long assetIndex) {
        if (assetIndex < 0L) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex);
        return (T)this;
    }

    public T strictEmptyAddressChecking(boolean strictEmptyAddressChecking) {
        this.strictEmptyAddressChecking = strictEmptyAddressChecking;
        return (T)this;
    }
}

