/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.transaction.Transaction;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class AssetClawbackTransactionBuilder<T extends AssetClawbackTransactionBuilder<T>>
extends TransactionBuilder<T> {
    protected Address assetClawbackFrom = null;
    protected Address assetReceiver = null;
    protected Address assetCloseTo = null;
    protected BigInteger assetAmount = null;
    protected BigInteger assetIndex = null;

    public static AssetClawbackTransactionBuilder<?> Builder() {
        return new AssetClawbackTransactionBuilder();
    }

    protected AssetClawbackTransactionBuilder() {
        super(Transaction.Type.AssetTransfer);
    }

    @Override
    protected void applyTo(Transaction txn) {
        Objects.requireNonNull(this.sender, "sender is required.");
        Objects.requireNonNull(this.assetClawbackFrom, "assetClawbackFrom is required.");
        Objects.requireNonNull(this.assetReceiver, "assetReceiver is required.");
        Objects.requireNonNull(this.assetAmount, "assetAmount is required.");
        Objects.requireNonNull(this.firstValid, "firstValid is required.");
        Objects.requireNonNull(this.lastValid, "lastValid is required.");
        Objects.requireNonNull(this.genesisHash, "genesisHash is required.");
        if (this.assetClawbackFrom != null) {
            txn.assetSender = this.assetClawbackFrom;
        }
        if (this.assetReceiver != null) {
            txn.assetReceiver = this.assetReceiver;
        }
        if (this.assetCloseTo != null) {
            txn.assetCloseTo = this.assetCloseTo;
        }
        if (this.assetAmount != null) {
            txn.assetAmount = this.assetAmount;
        }
        if (this.assetIndex != null) {
            txn.xferAsset = this.assetIndex;
        }
    }

    public T assetClawbackFrom(Address assetClawbackFrom) {
        this.assetClawbackFrom = assetClawbackFrom;
        return (T)this;
    }

    public T assetClawbackFrom(String assetClawbackFrom) {
        try {
            this.assetClawbackFrom = new Address(assetClawbackFrom);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T assetClawbackFrom(byte[] assetClawbackFrom) {
        this.assetClawbackFrom = new Address(assetClawbackFrom);
        return (T)this;
    }

    public T assetReceiver(Address assetReceiver) {
        this.assetReceiver = assetReceiver;
        return (T)this;
    }

    public T assetReceiver(String assetReceiver) {
        try {
            this.assetReceiver = new Address(assetReceiver);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T assetReceiver(byte[] assetReceiver) {
        this.assetReceiver = new Address(assetReceiver);
        return (T)this;
    }

    public T assetCloseTo(Address assetCloseTo) {
        this.assetCloseTo = assetCloseTo;
        return (T)this;
    }

    public T assetCloseTo(String assetCloseTo) {
        try {
            this.assetCloseTo = new Address(assetCloseTo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T assetCloseTo(byte[] assetCloseTo) {
        this.assetCloseTo = new Address(assetCloseTo);
        return (T)this;
    }

    public T assetIndex(BigInteger assetIndex) {
        this.assetIndex = assetIndex;
        return (T)this;
    }

    public T assetIndex(Integer assetIndex) {
        if (assetIndex < 0) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex.intValue());
        return (T)this;
    }

    public T assetIndex(Long assetIndex) {
        if (assetIndex < 0L) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex);
        return (T)this;
    }

    public T assetAmount(BigInteger assetAmount) {
        this.assetAmount = assetAmount;
        return (T)this;
    }

    public T assetAmount(Integer assetAmount) {
        if (assetAmount < 0) {
            throw new IllegalArgumentException("assetAmount cannot be a negative value");
        }
        this.assetAmount = BigInteger.valueOf(assetAmount.intValue());
        return (T)this;
    }

    public T assetAmount(Long assetAmount) {
        if (assetAmount < 0L) {
            throw new IllegalArgumentException("assetAmount cannot be a negative value");
        }
        this.assetAmount = BigInteger.valueOf(assetAmount);
        return (T)this;
    }
}

