/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.transaction.Transaction;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class AssetAcceptTransactionBuilder<T extends AssetAcceptTransactionBuilder<T>>
extends TransactionBuilder<T> {
    protected BigInteger assetIndex = null;

    public static AssetAcceptTransactionBuilder<?> Builder() {
        return new AssetAcceptTransactionBuilder();
    }

    protected AssetAcceptTransactionBuilder() {
        super(Transaction.Type.AssetTransfer);
    }

    @Override
    protected void applyTo(Transaction txn) {
        Objects.requireNonNull(this.assetIndex, "assetIndex is required");
        Objects.requireNonNull(this.sender, "acceptingAccount is required");
        if (this.assetIndex != null) {
            txn.xferAsset = this.assetIndex;
        }
        if (this.sender != null) {
            txn.assetReceiver = this.sender;
        }
        txn.amount = BigInteger.valueOf(0L);
    }

    public T acceptingAccount(Address acceptingAccount) {
        this.sender = acceptingAccount;
        return (T)this;
    }

    public T acceptingAccount(String acceptingAccount) {
        try {
            this.sender = new Address(acceptingAccount);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)this;
    }

    public T acceptingAccount(byte[] acceptingAccount) {
        this.sender = new Address(acceptingAccount);
        return (T)this;
    }

    public T assetIndex(BigInteger assetIndex) {
        this.assetIndex = assetIndex;
        return (T)this;
    }

    public T assetIndex(Integer assetIndex) {
        if (assetIndex < 0) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex.intValue());
        return (T)this;
    }

    public T assetIndex(Long assetIndex) {
        if (assetIndex < 0L) {
            throw new IllegalArgumentException("assetIndex cannot be a negative value");
        }
        this.assetIndex = BigInteger.valueOf(assetIndex);
        return (T)this;
    }
}

