/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.ApplicationUpdateTransactionBuilder;
import com.algorand.algosdk.builder.transaction.StateSchemaSetter;
import com.algorand.algosdk.logic.StateSchema;
import com.algorand.algosdk.transaction.Transaction;

public class ApplicationCreateTransactionBuilder<T extends ApplicationCreateTransactionBuilder<T>>
extends ApplicationUpdateTransactionBuilder<T>
implements StateSchemaSetter<T> {
    private StateSchema localStateSchema;
    private StateSchema globalStateSchema;
    private Long extraPages = 0L;

    public static ApplicationCreateTransactionBuilder<?> Builder() {
        return new ApplicationCreateTransactionBuilder();
    }

    public ApplicationCreateTransactionBuilder() {
        super.onCompletion(Transaction.OnCompletion.NoOpOC);
        super.applicationId(0L);
    }

    @Override
    protected void applyTo(Transaction txn) {
        txn.localStateSchema = this.localStateSchema;
        txn.globalStateSchema = this.globalStateSchema;
        txn.extraPages = this.extraPages;
        super.applyTo(txn);
    }

    @Override
    public T applicationId(Long appId) {
        if (appId != 0L) {
            throw new IllegalArgumentException("Application ID must be zero, do not set this for application create.");
        }
        return (T)this;
    }

    public T optIn(boolean optIn) {
        if (optIn) {
            super.onCompletion(Transaction.OnCompletion.OptInOC);
        } else {
            super.onCompletion(Transaction.OnCompletion.NoOpOC);
        }
        return (T)this;
    }

    @Override
    public T localStateSchema(StateSchema localStateSchema) {
        this.localStateSchema = localStateSchema;
        return (T)this;
    }

    @Override
    public T globalStateSchema(StateSchema globalStateSchema) {
        this.globalStateSchema = globalStateSchema;
        return (T)this;
    }

    @Override
    public T extraPages(Long extraPages) {
        if (extraPages == null || extraPages < 0L || extraPages > 3L) {
            throw new IllegalArgumentException("extraPages must be an integer between 0 and 3 inclusive");
        }
        this.extraPages = extraPages;
        return (T)this;
    }
}

