/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.builder.transaction;

import com.algorand.algosdk.builder.transaction.ApplicationCallReferencesSetter;
import com.algorand.algosdk.builder.transaction.TransactionBuilder;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.Encoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class ApplicationBaseTransactionBuilder<T extends ApplicationBaseTransactionBuilder<T>>
extends TransactionBuilder<T>
implements ApplicationCallReferencesSetter<T> {
    private Transaction.OnCompletion onCompletion;
    private List<byte[]> applicationArgs;
    private List<Address> accounts;
    private List<Long> foreignApps;
    private List<Long> foreignAssets;
    private Long applicationId;

    protected ApplicationBaseTransactionBuilder() {
        super(Transaction.Type.ApplicationCall);
    }

    @Override
    protected void applyTo(Transaction txn) {
        Objects.requireNonNull(this.onCompletion, "OnCompletion is required, please file a bug report.");
        Objects.requireNonNull(this.applicationId);
        if (this.applicationId != null) {
            txn.applicationId = this.applicationId;
        }
        if (this.onCompletion != null) {
            txn.onCompletion = this.onCompletion;
        }
        if (this.applicationArgs != null) {
            txn.applicationArgs = this.applicationArgs;
        }
        if (this.accounts != null) {
            txn.accounts = this.accounts;
        }
        if (this.foreignApps != null) {
            txn.foreignApps = this.foreignApps;
        }
        if (this.foreignAssets != null) {
            txn.foreignAssets = this.foreignAssets;
        }
    }

    @Override
    public T applicationId(Long applicationId) {
        this.applicationId = applicationId;
        return (T)this;
    }

    protected T onCompletion(Transaction.OnCompletion onCompletion) {
        this.onCompletion = onCompletion;
        return (T)this;
    }

    public T args(List<byte[]> args) {
        this.applicationArgs = args;
        return (T)this;
    }

    public T argsBase64Encoded(List<String> args) {
        ArrayList<byte[]> decodedArgs = new ArrayList<byte[]>();
        for (String arg : args) {
            decodedArgs.add(Encoder.decodeFromBase64(arg));
        }
        return this.args(decodedArgs);
    }

    @Override
    public T accounts(List<Address> accounts) {
        this.accounts = accounts;
        return (T)this;
    }

    @Override
    public T foreignApps(List<Long> foreignApps) {
        this.foreignApps = foreignApps;
        return (T)this;
    }

    @Override
    public T foreignAssets(List<Long> foreignAssets) {
        this.foreignAssets = foreignAssets;
        return (T)this;
    }
}

