/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.auction;

import com.algorand.algosdk.auction.Bid;
import com.algorand.algosdk.crypto.MultisigSignature;
import com.algorand.algosdk.crypto.Signature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

@JsonPropertyOrder(alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class SignedBid {
    @JsonProperty(value="bid")
    public Bid bid = new Bid();
    @JsonProperty(value="sig")
    public Signature sig = new Signature();
    @JsonProperty(value="msig")
    public MultisigSignature mSig = new MultisigSignature();

    public SignedBid(Bid bid, Signature sig, MultisigSignature mSig) {
        this.bid = Objects.requireNonNull(bid, "tx must not be null");
        this.mSig = Objects.requireNonNull(mSig, "mSig must not be null");
        this.sig = Objects.requireNonNull(sig, "sig must not be null");
    }

    public SignedBid(Bid bid, Signature sig) {
        this(bid, sig, new MultisigSignature());
    }

    public SignedBid(Bid bid, MultisigSignature mSig) {
        this(bid, new Signature(), mSig);
    }

    public SignedBid() {
    }

    @JsonCreator
    public SignedBid(@JsonProperty(value="bid") Bid bid, @JsonProperty(value="sig") byte[] sig, @JsonProperty(value="msig") MultisigSignature mSig) {
        if (bid != null) {
            this.bid = bid;
        }
        if (sig != null) {
            this.sig = new Signature(sig);
        }
        if (mSig != null) {
            this.mSig = mSig;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignedBid signedBid = (SignedBid)o;
        return Objects.equals(this.bid, signedBid.bid) && Objects.equals(this.sig, signedBid.sig) && Objects.equals(this.mSig, signedBid.mSig);
    }
}

