/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.auction;

import com.algorand.algosdk.crypto.Address;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigInteger;

@JsonPropertyOrder(alphabetic=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Bid {
    @JsonProperty(value="bidder")
    public Address bidderKey = new Address();
    @JsonProperty(value="auc")
    public Address auctionKey = new Address();
    @JsonProperty(value="cur")
    public BigInteger bidCurrency = BigInteger.valueOf(0L);
    @JsonProperty(value="price")
    public BigInteger maxPrice = BigInteger.valueOf(0L);
    @JsonProperty(value="id")
    public BigInteger bidID = BigInteger.valueOf(0L);
    @JsonProperty(value="aid")
    public BigInteger auctionID = BigInteger.valueOf(0L);

    public Bid(Address bidderKey, Address auctionKey, BigInteger bidCurrency, BigInteger maxPrice, BigInteger bidID, BigInteger auctionID) {
        if (bidderKey != null) {
            this.bidderKey = bidderKey;
        }
        if (auctionKey != null) {
            this.auctionKey = auctionKey;
        }
        if (bidCurrency != null) {
            this.bidCurrency = bidCurrency;
        }
        if (maxPrice != null) {
            this.maxPrice = maxPrice;
        }
        if (bidID != null) {
            this.bidID = bidID;
        }
        if (auctionID != null) {
            this.auctionID = auctionID;
        }
    }

    @JsonCreator
    public Bid(@JsonProperty(value="bidder") byte[] bidderKey, @JsonProperty(value="auc") byte[] auctionKey, @JsonProperty(value="cur") BigInteger bidCurrency, @JsonProperty(value="price") BigInteger maxPrice, @JsonProperty(value="id") BigInteger bidID, @JsonProperty(value="aid") BigInteger auctionID) {
        if (bidderKey != null) {
            this.bidderKey = new Address(bidderKey);
        }
        if (auctionKey != null) {
            this.auctionKey = new Address(auctionKey);
        }
        if (bidCurrency != null) {
            this.bidCurrency = bidCurrency;
        }
        if (maxPrice != null) {
            this.maxPrice = maxPrice;
        }
        if (bidID != null) {
            this.bidID = bidID;
        }
        if (auctionID != null) {
            this.auctionID = auctionID;
        }
    }

    public Bid() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bid bid = (Bid)o;
        return this.bidderKey.equals(bid.bidderKey) && this.auctionKey.equals(bid.auctionKey) && this.bidCurrency.equals(bid.bidCurrency) && this.maxPrice.equals(bid.maxPrice) && this.bidID.equals(bid.bidID) && this.auctionID.equals(bid.auctionID);
    }
}

