/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.algod.client.model;

import com.algorand.algosdk.algod.client.model.PaymentTransactionType;
import com.algorand.algosdk.algod.client.model.TransactionResults;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Transaction contains all fields common to all transactions and serves as an envelope to all transactions type")
@Deprecated
public class Transaction {
    @SerializedName(value="fee")
    private BigInteger fee = null;
    @SerializedName(value="first-round")
    private BigInteger firstRound = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="fromrewards")
    private BigInteger fromrewards = null;
    @SerializedName(value="genesisID")
    private String genesisID = null;
    @SerializedName(value="genesishashb64")
    private byte[] genesishashb64 = null;
    @SerializedName(value="last-round")
    private BigInteger lastRound = null;
    @SerializedName(value="noteb64")
    private byte[] noteb64 = null;
    @SerializedName(value="payment")
    private PaymentTransactionType payment = null;
    @SerializedName(value="poolerror")
    private String poolerror = null;
    @SerializedName(value="round")
    private BigInteger round = null;
    @SerializedName(value="tx")
    private String tx = null;
    @SerializedName(value="txresults")
    private TransactionResults txresults = null;
    @SerializedName(value="type")
    private String type = null;

    public Transaction fee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(required=true, value="Fee is the transaction fee")
    public BigInteger getFee() {
        return this.fee;
    }

    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public Transaction firstRound(BigInteger firstRound) {
        this.firstRound = firstRound;
        return this;
    }

    @ApiModelProperty(required=true, value="FirstRound indicates the first valid round for this transaction")
    public BigInteger getFirstRound() {
        return this.firstRound;
    }

    public void setFirstRound(BigInteger firstRound) {
        this.firstRound = firstRound;
    }

    public Transaction from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(required=true, value="From is the sender's address")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Transaction fromrewards(BigInteger fromrewards) {
        this.fromrewards = fromrewards;
        return this;
    }

    @ApiModelProperty(value="FromRewards is the amount of pending rewards applied to the From account as part of this transaction.")
    public BigInteger getFromrewards() {
        return this.fromrewards;
    }

    public void setFromrewards(BigInteger fromrewards) {
        this.fromrewards = fromrewards;
    }

    public Transaction genesisID(String genesisID) {
        this.genesisID = genesisID;
        return this;
    }

    @ApiModelProperty(required=true, value="Genesis ID")
    public String getGenesisID() {
        return this.genesisID;
    }

    public void setGenesisID(String genesisID) {
        this.genesisID = genesisID;
    }

    public Transaction genesishashb64(byte[] genesishashb64) {
        this.genesishashb64 = genesishashb64;
        return this;
    }

    @ApiModelProperty(required=true, value="Genesis hash")
    public byte[] getGenesishashb64() {
        return this.genesishashb64;
    }

    public void setGenesishashb64(byte[] genesishashb64) {
        this.genesishashb64 = genesishashb64;
    }

    public Transaction lastRound(BigInteger lastRound) {
        this.lastRound = lastRound;
        return this;
    }

    @ApiModelProperty(required=true, value="LastRound indicates the last valid round for this transaction")
    public BigInteger getLastRound() {
        return this.lastRound;
    }

    public void setLastRound(BigInteger lastRound) {
        this.lastRound = lastRound;
    }

    public Transaction noteb64(byte[] noteb64) {
        this.noteb64 = noteb64;
        return this;
    }

    @ApiModelProperty(value="Note is a free form data")
    public byte[] getNoteb64() {
        return this.noteb64;
    }

    public void setNoteb64(byte[] noteb64) {
        this.noteb64 = noteb64;
    }

    public Transaction payment(PaymentTransactionType payment) {
        this.payment = payment;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentTransactionType getPayment() {
        return this.payment;
    }

    public void setPayment(PaymentTransactionType payment) {
        this.payment = payment;
    }

    public Transaction poolerror(String poolerror) {
        this.poolerror = poolerror;
        return this;
    }

    @ApiModelProperty(value="PoolError indicates the transaction was evicted from this node's transaction pool (if non-empty).  A non-empty PoolError does not guarantee that the transaction will never be committed; other nodes may not have evicted the transaction and may attempt to commit it in the future.")
    public String getPoolerror() {
        return this.poolerror;
    }

    public void setPoolerror(String poolerror) {
        this.poolerror = poolerror;
    }

    public Transaction round(BigInteger round) {
        this.round = round;
        return this;
    }

    @ApiModelProperty(value="ConfirmedRound indicates the block number this transaction appeared in")
    public BigInteger getRound() {
        return this.round;
    }

    public void setRound(BigInteger round) {
        this.round = round;
    }

    public Transaction tx(String tx) {
        this.tx = tx;
        return this;
    }

    @ApiModelProperty(required=true, value="TxID is the transaction ID")
    public String getTx() {
        return this.tx;
    }

    public void setTx(String tx) {
        this.tx = tx;
    }

    public Transaction txresults(TransactionResults txresults) {
        this.txresults = txresults;
        return this;
    }

    @ApiModelProperty(value="")
    public TransactionResults getTxresults() {
        return this.txresults;
    }

    public void setTxresults(TransactionResults txresults) {
        this.txresults = txresults;
    }

    public Transaction type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return ObjectUtils.equals((Object)this.fee, (Object)transaction.fee) && ObjectUtils.equals((Object)this.firstRound, (Object)transaction.firstRound) && ObjectUtils.equals((Object)this.from, (Object)transaction.from) && ObjectUtils.equals((Object)this.fromrewards, (Object)transaction.fromrewards) && ObjectUtils.equals((Object)this.genesisID, (Object)transaction.genesisID) && ObjectUtils.equals((Object)this.genesishashb64, (Object)transaction.genesishashb64) && ObjectUtils.equals((Object)this.lastRound, (Object)transaction.lastRound) && ObjectUtils.equals((Object)this.noteb64, (Object)transaction.noteb64) && ObjectUtils.equals((Object)this.payment, (Object)transaction.payment) && ObjectUtils.equals((Object)this.poolerror, (Object)transaction.poolerror) && ObjectUtils.equals((Object)this.round, (Object)transaction.round) && ObjectUtils.equals((Object)this.tx, (Object)transaction.tx) && ObjectUtils.equals((Object)this.txresults, (Object)transaction.txresults) && ObjectUtils.equals((Object)this.type, (Object)transaction.type);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.fee, this.firstRound, this.from, this.fromrewards, this.genesisID, this.genesishashb64, this.lastRound, this.noteb64, this.payment, this.poolerror, this.round, this.tx, this.txresults, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    firstRound: ").append(this.toIndentedString(this.firstRound)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    fromrewards: ").append(this.toIndentedString(this.fromrewards)).append("\n");
        sb.append("    genesisID: ").append(this.toIndentedString(this.genesisID)).append("\n");
        sb.append("    genesishashb64: ").append(this.toIndentedString(this.genesishashb64)).append("\n");
        sb.append("    lastRound: ").append(this.toIndentedString(this.lastRound)).append("\n");
        sb.append("    noteb64: ").append(this.toIndentedString(this.noteb64)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    poolerror: ").append(this.toIndentedString(this.poolerror)).append("\n");
        sb.append("    round: ").append(this.toIndentedString(this.round)).append("\n");
        sb.append("    tx: ").append(this.toIndentedString(this.tx)).append("\n");
        sb.append("    txresults: ").append(this.toIndentedString(this.txresults)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

