/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.algod.client.model;

import com.algorand.algosdk.algod.client.model.TransactionList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Block contains a block information")
@Deprecated
public class Block {
    @SerializedName(value="currentProtocol")
    private String currentProtocol = null;
    @SerializedName(value="frac")
    private BigInteger frac = null;
    @SerializedName(value="hash")
    private String hash = null;
    @SerializedName(value="nextProtocol")
    private String nextProtocol = null;
    @SerializedName(value="nextProtocolApprovals")
    private BigInteger nextProtocolApprovals = null;
    @SerializedName(value="nextProtocolSwitchOn")
    private BigInteger nextProtocolSwitchOn = null;
    @SerializedName(value="nextProtocolVoteBefore")
    private BigInteger nextProtocolVoteBefore = null;
    @SerializedName(value="period")
    private BigInteger period = null;
    @SerializedName(value="previousBlockHash")
    private String previousBlockHash = null;
    @SerializedName(value="proposer")
    private String proposer = null;
    @SerializedName(value="rate")
    private BigInteger rate = null;
    @SerializedName(value="reward")
    private BigInteger reward = null;
    @SerializedName(value="round")
    private BigInteger round = null;
    @SerializedName(value="seed")
    private String seed = null;
    @SerializedName(value="timestamp")
    private BigInteger timestamp = null;
    @SerializedName(value="txnRoot")
    private String txnRoot = null;
    @SerializedName(value="txns")
    private TransactionList txns = null;
    @SerializedName(value="upgradeApprove")
    private Boolean upgradeApprove = null;
    @SerializedName(value="upgradePropose")
    private String upgradePropose = null;

    public Block currentProtocol(String currentProtocol) {
        this.currentProtocol = currentProtocol;
        return this;
    }

    @ApiModelProperty(required=true, value="CurrentProtocol is a string that represents the current protocol")
    public String getCurrentProtocol() {
        return this.currentProtocol;
    }

    public void setCurrentProtocol(String currentProtocol) {
        this.currentProtocol = currentProtocol;
    }

    public Block frac(BigInteger frac) {
        this.frac = frac;
        return this;
    }

    @ApiModelProperty(value="The number of leftover MicroAlgos after the distribution of RewardsRate/rewardUnits MicroAlgos for every reward unit in the next round.")
    public BigInteger getFrac() {
        return this.frac;
    }

    public void setFrac(BigInteger frac) {
        this.frac = frac;
    }

    public Block hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(required=true, value="Hash is the current block hash")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Block nextProtocol(String nextProtocol) {
        this.nextProtocol = nextProtocol;
        return this;
    }

    @ApiModelProperty(required=true, value="NextProtocol is a string that represents the next proposed protocol")
    public String getNextProtocol() {
        return this.nextProtocol;
    }

    public void setNextProtocol(String nextProtocol) {
        this.nextProtocol = nextProtocol;
    }

    public Block nextProtocolApprovals(BigInteger nextProtocolApprovals) {
        this.nextProtocolApprovals = nextProtocolApprovals;
        return this;
    }

    @ApiModelProperty(required=true, value="NextProtocolApprovals is the number of blocks which approved the protocol upgrade")
    public BigInteger getNextProtocolApprovals() {
        return this.nextProtocolApprovals;
    }

    public void setNextProtocolApprovals(BigInteger nextProtocolApprovals) {
        this.nextProtocolApprovals = nextProtocolApprovals;
    }

    public Block nextProtocolSwitchOn(BigInteger nextProtocolSwitchOn) {
        this.nextProtocolSwitchOn = nextProtocolSwitchOn;
        return this;
    }

    @ApiModelProperty(required=true, value="NextProtocolSwitchOn is the round on which the protocol upgrade will take effect")
    public BigInteger getNextProtocolSwitchOn() {
        return this.nextProtocolSwitchOn;
    }

    public void setNextProtocolSwitchOn(BigInteger nextProtocolSwitchOn) {
        this.nextProtocolSwitchOn = nextProtocolSwitchOn;
    }

    public Block nextProtocolVoteBefore(BigInteger nextProtocolVoteBefore) {
        this.nextProtocolVoteBefore = nextProtocolVoteBefore;
        return this;
    }

    @ApiModelProperty(required=true, value="NextProtocolVoteBefore is the deadline round for this protocol upgrade (No votes will be consider after this round)")
    public BigInteger getNextProtocolVoteBefore() {
        return this.nextProtocolVoteBefore;
    }

    public void setNextProtocolVoteBefore(BigInteger nextProtocolVoteBefore) {
        this.nextProtocolVoteBefore = nextProtocolVoteBefore;
    }

    public Block period(BigInteger period) {
        this.period = period;
        return this;
    }

    @ApiModelProperty(required=true, value="Period is the period on which the block was confirmed")
    public BigInteger getPeriod() {
        return this.period;
    }

    public void setPeriod(BigInteger period) {
        this.period = period;
    }

    public Block previousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
        return this;
    }

    @ApiModelProperty(required=true, value="PreviousBlockHash is the previous block hash")
    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public Block proposer(String proposer) {
        this.proposer = proposer;
        return this;
    }

    @ApiModelProperty(required=true, value="Proposer is the address of this block proposer")
    public String getProposer() {
        return this.proposer;
    }

    public void setProposer(String proposer) {
        this.proposer = proposer;
    }

    public Block rate(BigInteger rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="The number of new MicroAlgos added to the participation stake from rewards at the next round.")
    public BigInteger getRate() {
        return this.rate;
    }

    public void setRate(BigInteger rate) {
        this.rate = rate;
    }

    public Block reward(BigInteger reward) {
        this.reward = reward;
        return this;
    }

    @ApiModelProperty(value="RewardsLevel specifies how many rewards, in MicroAlgos, have been distributed to each config.Protocol.RewardUnit of MicroAlgos since genesis.")
    public BigInteger getReward() {
        return this.reward;
    }

    public void setReward(BigInteger reward) {
        this.reward = reward;
    }

    public Block round(BigInteger round) {
        this.round = round;
        return this;
    }

    @ApiModelProperty(required=true, value="Round is the current round on which this block was appended to the chain")
    public BigInteger getRound() {
        return this.round;
    }

    public void setRound(BigInteger round) {
        this.round = round;
    }

    public Block seed(String seed) {
        this.seed = seed;
        return this;
    }

    @ApiModelProperty(required=true, value="Seed is the sortition seed")
    public String getSeed() {
        return this.seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public Block timestamp(BigInteger timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="TimeStamp in seconds since epoch")
    public BigInteger getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(BigInteger timestamp) {
        this.timestamp = timestamp;
    }

    public Block txnRoot(String txnRoot) {
        this.txnRoot = txnRoot;
        return this;
    }

    @ApiModelProperty(required=true, value="TransactionsRoot authenticates the set of transactions appearing in the block. More specifically, it's the root of a merkle tree whose leaves are the block's Txids, in lexicographic order. For the empty block, it's 0. Note that the TxnRoot does not authenticate the signatures on the transactions, only the transactions themselves. Two blocks with the same transactions but in a different order and with different signatures will have the same TxnRoot.")
    public String getTxnRoot() {
        return this.txnRoot;
    }

    public void setTxnRoot(String txnRoot) {
        this.txnRoot = txnRoot;
    }

    public Block txns(TransactionList txns) {
        this.txns = txns;
        return this;
    }

    @ApiModelProperty(value="")
    public TransactionList getTxns() {
        return this.txns;
    }

    public void setTxns(TransactionList txns) {
        this.txns = txns;
    }

    public Block upgradeApprove(Boolean upgradeApprove) {
        this.upgradeApprove = upgradeApprove;
        return this;
    }

    @ApiModelProperty(required=true, value="UpgradeApprove indicates a yes vote for the current proposal")
    public Boolean isUpgradeApprove() {
        return this.upgradeApprove;
    }

    public void setUpgradeApprove(Boolean upgradeApprove) {
        this.upgradeApprove = upgradeApprove;
    }

    public Block upgradePropose(String upgradePropose) {
        this.upgradePropose = upgradePropose;
        return this;
    }

    @ApiModelProperty(required=true, value="UpgradePropose indicates a proposed upgrade")
    public String getUpgradePropose() {
        return this.upgradePropose;
    }

    public void setUpgradePropose(String upgradePropose) {
        this.upgradePropose = upgradePropose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        return ObjectUtils.equals((Object)this.currentProtocol, (Object)block.currentProtocol) && ObjectUtils.equals((Object)this.frac, (Object)block.frac) && ObjectUtils.equals((Object)this.hash, (Object)block.hash) && ObjectUtils.equals((Object)this.nextProtocol, (Object)block.nextProtocol) && ObjectUtils.equals((Object)this.nextProtocolApprovals, (Object)block.nextProtocolApprovals) && ObjectUtils.equals((Object)this.nextProtocolSwitchOn, (Object)block.nextProtocolSwitchOn) && ObjectUtils.equals((Object)this.nextProtocolVoteBefore, (Object)block.nextProtocolVoteBefore) && ObjectUtils.equals((Object)this.period, (Object)block.period) && ObjectUtils.equals((Object)this.previousBlockHash, (Object)block.previousBlockHash) && ObjectUtils.equals((Object)this.proposer, (Object)block.proposer) && ObjectUtils.equals((Object)this.rate, (Object)block.rate) && ObjectUtils.equals((Object)this.reward, (Object)block.reward) && ObjectUtils.equals((Object)this.round, (Object)block.round) && ObjectUtils.equals((Object)this.seed, (Object)block.seed) && ObjectUtils.equals((Object)this.timestamp, (Object)block.timestamp) && ObjectUtils.equals((Object)this.txnRoot, (Object)block.txnRoot) && ObjectUtils.equals((Object)this.txns, (Object)block.txns) && ObjectUtils.equals((Object)this.upgradeApprove, (Object)block.upgradeApprove) && ObjectUtils.equals((Object)this.upgradePropose, (Object)block.upgradePropose);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.currentProtocol, this.frac, this.hash, this.nextProtocol, this.nextProtocolApprovals, this.nextProtocolSwitchOn, this.nextProtocolVoteBefore, this.period, this.previousBlockHash, this.proposer, this.rate, this.reward, this.round, this.seed, this.timestamp, this.txnRoot, this.txns, this.upgradeApprove, this.upgradePropose});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Block {\n");
        sb.append("    currentProtocol: ").append(this.toIndentedString(this.currentProtocol)).append("\n");
        sb.append("    frac: ").append(this.toIndentedString(this.frac)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    nextProtocol: ").append(this.toIndentedString(this.nextProtocol)).append("\n");
        sb.append("    nextProtocolApprovals: ").append(this.toIndentedString(this.nextProtocolApprovals)).append("\n");
        sb.append("    nextProtocolSwitchOn: ").append(this.toIndentedString(this.nextProtocolSwitchOn)).append("\n");
        sb.append("    nextProtocolVoteBefore: ").append(this.toIndentedString(this.nextProtocolVoteBefore)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    previousBlockHash: ").append(this.toIndentedString(this.previousBlockHash)).append("\n");
        sb.append("    proposer: ").append(this.toIndentedString(this.proposer)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    reward: ").append(this.toIndentedString(this.reward)).append("\n");
        sb.append("    round: ").append(this.toIndentedString(this.round)).append("\n");
        sb.append("    seed: ").append(this.toIndentedString(this.seed)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    txnRoot: ").append(this.toIndentedString(this.txnRoot)).append("\n");
        sb.append("    txns: ").append(this.toIndentedString(this.txns)).append("\n");
        sb.append("    upgradeApprove: ").append(this.toIndentedString(this.upgradeApprove)).append("\n");
        sb.append("    upgradePropose: ").append(this.toIndentedString(this.upgradePropose)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

