/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.algod.client.model;

import com.algorand.algosdk.algod.client.model.AssetHolding;
import com.algorand.algosdk.algod.client.model.AssetParams;
import com.algorand.algosdk.algod.client.model.Participation;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Account Description")
@Deprecated
public class Account {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="amount")
    private BigInteger amount = null;
    @SerializedName(value="amountwithoutpendingrewards")
    private BigInteger amountwithoutpendingrewards = null;
    @SerializedName(value="assets")
    private Map<BigInteger, AssetHolding> assets = null;
    @SerializedName(value="participation")
    private Participation participation = null;
    @SerializedName(value="pendingrewards")
    private BigInteger pendingrewards = null;
    @SerializedName(value="rewards")
    private BigInteger rewards = null;
    @SerializedName(value="round")
    private BigInteger round = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="thisassettotal")
    private Map<BigInteger, AssetParams> thisassettotal = null;

    public Account address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="Address indicates the account public key")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Account amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount indicates the total number of MicroAlgos in the account")
    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public Account amountwithoutpendingrewards(BigInteger amountwithoutpendingrewards) {
        this.amountwithoutpendingrewards = amountwithoutpendingrewards;
        return this;
    }

    @ApiModelProperty(required=true, value="AmountWithoutPendingRewards specifies the amount of MicroAlgos in the account, without the pending rewards.")
    public BigInteger getAmountwithoutpendingrewards() {
        return this.amountwithoutpendingrewards;
    }

    public void setAmountwithoutpendingrewards(BigInteger amountwithoutpendingrewards) {
        this.amountwithoutpendingrewards = amountwithoutpendingrewards;
    }

    public Account assets(Map<BigInteger, AssetHolding> assets) {
        this.assets = assets;
        return this;
    }

    @ApiModelProperty(value="Assets specifies the holdings of assets by this account, indexed by the asset ID.")
    public AssetHolding getHolding(BigInteger assetIndex) {
        return this.assets.get(assetIndex);
    }

    public void setAssets(Map<BigInteger, AssetHolding> assets) {
        this.assets = assets;
    }

    public Account participation(Participation participation) {
        this.participation = participation;
        return this;
    }

    @ApiModelProperty(value="")
    public Participation getParticipation() {
        return this.participation;
    }

    public void setParticipation(Participation participation) {
        this.participation = participation;
    }

    public Account pendingrewards(BigInteger pendingrewards) {
        this.pendingrewards = pendingrewards;
        return this;
    }

    @ApiModelProperty(required=true, value="PendingRewards specifies the amount of MicroAlgos of pending rewards in this account.")
    public BigInteger getPendingrewards() {
        return this.pendingrewards;
    }

    public void setPendingrewards(BigInteger pendingrewards) {
        this.pendingrewards = pendingrewards;
    }

    public Account rewards(BigInteger rewards) {
        this.rewards = rewards;
        return this;
    }

    @ApiModelProperty(required=true, value="Rewards indicates the total rewards of MicroAlgos the account has received, including pending rewards.")
    public BigInteger getRewards() {
        return this.rewards;
    }

    public void setRewards(BigInteger rewards) {
        this.rewards = rewards;
    }

    public Account round(BigInteger round) {
        this.round = round;
        return this;
    }

    @ApiModelProperty(required=true, value="Round indicates the round for which this information is relevant")
    public BigInteger getRound() {
        return this.round;
    }

    public void setRound(BigInteger round) {
        this.round = round;
    }

    public Account status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status indicates the delegation status of the account's MicroAlgos Offline - indicates that the associated account is delegated. Online  - indicates that the associated account used as part of the delegation pool. NotParticipating - indicates that the associated account is neither a delegator nor a delegate.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Account thisassettotal(Map<BigInteger, AssetParams> thisassettotal) {
        this.thisassettotal = thisassettotal;
        return this;
    }

    @ApiModelProperty(value="AssetParams specifies the parameters of assets created by this account.")
    public Map<BigInteger, AssetParams> getThisassettotal() {
        return this.thisassettotal;
    }

    public void setThisassettotal(Map<BigInteger, AssetParams> thisassettotal) {
        this.thisassettotal = thisassettotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return ObjectUtils.equals((Object)this.address, (Object)account.address) && ObjectUtils.equals((Object)this.amount, (Object)account.amount) && ObjectUtils.equals((Object)this.amountwithoutpendingrewards, (Object)account.amountwithoutpendingrewards) && ObjectUtils.equals(this.assets, account.assets) && ObjectUtils.equals((Object)this.participation, (Object)account.participation) && ObjectUtils.equals((Object)this.pendingrewards, (Object)account.pendingrewards) && ObjectUtils.equals((Object)this.rewards, (Object)account.rewards) && ObjectUtils.equals((Object)this.round, (Object)account.round) && ObjectUtils.equals((Object)this.status, (Object)account.status) && ObjectUtils.equals(this.thisassettotal, account.thisassettotal);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.address, this.amount, this.amountwithoutpendingrewards, this.assets, this.participation, this.pendingrewards, this.rewards, this.round, this.status, this.thisassettotal});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountwithoutpendingrewards: ").append(this.toIndentedString(this.amountwithoutpendingrewards)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    participation: ").append(this.toIndentedString(this.participation)).append("\n");
        sb.append("    pendingrewards: ").append(this.toIndentedString(this.pendingrewards)).append("\n");
        sb.append("    rewards: ").append(this.toIndentedString(this.rewards)).append("\n");
        sb.append("    round: ").append(this.toIndentedString(this.round)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    thisassettotal: ").append(this.toIndentedString(this.thisassettotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

