/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.account;

import com.algorand.algosdk.account.Account;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Ed25519PublicKey;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.crypto.MultisigAddress;
import com.algorand.algosdk.crypto.MultisigSignature;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TxnSigner;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LogicSigAccount {
    public final Ed25519PublicKey sigKey;
    public final LogicsigSignature lsig;

    public LogicSigAccount(byte[] logic, List<byte[]> args) {
        this.lsig = new LogicsigSignature(logic, args);
        this.sigKey = null;
    }

    public LogicSigAccount(byte[] logic, List<byte[]> args, PrivateKey privateKey) throws NoSuchAlgorithmException, IOException {
        this.lsig = new LogicsigSignature(logic, args);
        Account signerAccount = new Account(privateKey);
        signerAccount.signLogicsig(this.lsig);
        this.sigKey = signerAccount.getEd25519PublicKey();
    }

    public LogicSigAccount(byte[] logic, List<byte[]> args, PrivateKey privateKey, MultisigAddress ma) throws IOException, NoSuchAlgorithmException {
        this.lsig = new LogicsigSignature(logic, args);
        Account signerAccount = new Account(privateKey);
        signerAccount.signLogicsig(this.lsig, ma);
        this.sigKey = null;
    }

    public void appendMultiSig(PrivateKey privateKey) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        Account signerAccount = new Account(privateKey);
        signerAccount.appendToLogicsig(this.lsig);
    }

    public LogicSigAccount(LogicsigSignature lsig, Ed25519PublicKey signerPublicKey) throws IllegalArgumentException, NoSuchAlgorithmException {
        boolean hasMsig;
        boolean hasSig = lsig.sig != null;
        boolean bl = hasMsig = lsig.msig != null;
        if (hasSig && hasMsig) {
            throw new IllegalArgumentException("Logicsig has too many signatures, at most one of Sig or Msig may be defined");
        }
        if (hasSig) {
            if (signerPublicKey == null) {
                throw new IllegalArgumentException("Cannot generate LogicSigAccount from single-signed LogicSig and a null public key");
            }
            if (!lsig.verify(new Address(signerPublicKey.getBytes()))) {
                throw new IllegalArgumentException("Cannot verify the sig in LogicSig with the public key provided");
            }
            this.lsig = lsig;
            this.sigKey = signerPublicKey;
            return;
        }
        if (signerPublicKey != null) {
            throw new IllegalArgumentException("Cannot generate LogicSigAccount from multi-sig LogicSig and a public key");
        }
        this.lsig = lsig;
        this.sigKey = null;
    }

    public boolean isDelegated() {
        boolean hasSig = this.lsig.sig != null;
        boolean hasMsig = this.lsig.msig != null;
        return hasSig || hasMsig;
    }

    public Address getAddress() throws NoSuchAlgorithmException, IllegalArgumentException {
        boolean hasMsig;
        boolean hasSig = this.lsig.sig != null;
        boolean bl = hasMsig = this.lsig.msig != null;
        if (hasSig && hasMsig) {
            throw new IllegalArgumentException("Logicsig has too many signatures, at most one of Sig or Msig may be defined");
        }
        if (hasSig) {
            byte[] sigKeyRaw = this.sigKey.getBytes();
            return new Address(sigKeyRaw);
        }
        if (hasMsig) {
            ArrayList<Ed25519PublicKey> pkFromSubSig = new ArrayList<Ed25519PublicKey>();
            for (MultisigSignature.MultisigSubsig subSig : this.lsig.msig.subsigs) {
                pkFromSubSig.add(subSig.key);
            }
            MultisigAddress ma = new MultisigAddress(this.lsig.msig.version, this.lsig.msig.threshold, pkFromSubSig);
            return ma.toAddress();
        }
        return this.lsig.toAddress();
    }

    public SignedTransaction signLogicSigTransaction(Transaction tx) throws NoSuchAlgorithmException, IOException {
        return Account.signLogicTransactionWithAddress(this.lsig, this.getAddress(), tx);
    }

    public TxnSigner getTransactionSigner() {
        final LogicSigAccount self = this;
        return new TxnSigner(){

            public int hashCode() {
                return Objects.hash(2, self);
            }

            @Override
            public SignedTransaction[] signTxnGroup(Transaction[] txnGroup, int[] indicesToSign) throws NoSuchAlgorithmException, IOException {
                SignedTransaction[] sTxn = new SignedTransaction[indicesToSign.length];
                for (int i = 0; i < indicesToSign.length; ++i) {
                    sTxn[i] = self.signLogicSigTransaction(txnGroup[indicesToSign[i]]);
                }
                return sTxn;
            }
        };
    }
}

