/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.account;

import com.algorand.algosdk.auction.Bid;
import com.algorand.algosdk.auction.SignedBid;
import com.algorand.algosdk.crypto.Address;
import com.algorand.algosdk.crypto.Ed25519PublicKey;
import com.algorand.algosdk.crypto.LogicsigSignature;
import com.algorand.algosdk.crypto.MultisigAddress;
import com.algorand.algosdk.crypto.MultisigSignature;
import com.algorand.algosdk.crypto.Signature;
import com.algorand.algosdk.mnemonic.Mnemonic;
import com.algorand.algosdk.transaction.SignedTransaction;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.transaction.TxnSigner;
import com.algorand.algosdk.util.CryptoProvider;
import com.algorand.algosdk.util.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;

public class Account {
    private final KeyPair privateKeyPair;
    private final Address address;
    private static final String KEY_ALGO = "Ed25519";
    private static final String SIGN_ALGO = "EdDSA";
    private static final int PK_SIZE = 32;
    private static final int PK_X509_PREFIX_LENGTH = 12;
    private static final int SK_PKCS_PREFIX_LENGTH = 16;
    private static final int SK_SEPARATOR_LENGTH = 3;
    private static final int SK_SIZE = 32;
    private static final int SK_SIZE_BITS = 256;
    private static final byte[] BID_SIGN_PREFIX = "aB".getBytes(StandardCharsets.UTF_8);
    private static final byte[] BYTES_SIGN_PREFIX = "MX".getBytes(StandardCharsets.UTF_8);
    private static final byte[] PROGDATA_SIGN_PREFIX = "ProgData".getBytes(StandardCharsets.UTF_8);
    public static final BigInteger MIN_TX_FEE_UALGOS = BigInteger.valueOf(1000L);

    public Account() throws NoSuchAlgorithmException {
        this((SecureRandom)null);
    }

    public Account(byte[] seed) throws NoSuchAlgorithmException {
        this(new FixedSecureRandom(seed));
    }

    public Account(String mnemonic) throws GeneralSecurityException {
        this(Mnemonic.toKey(mnemonic));
    }

    private Account(SecureRandom randomSrc) throws NoSuchAlgorithmException {
        CryptoProvider.setupIfNeeded();
        KeyPairGenerator gen = KeyPairGenerator.getInstance(KEY_ALGO);
        if (randomSrc != null) {
            gen.initialize(256, randomSrc);
        }
        this.privateKeyPair = gen.generateKeyPair();
        byte[] raw = this.getClearTextPublicKey();
        this.address = new Address(Arrays.copyOf(raw, raw.length));
    }

    public Account(KeyPair pkPair) {
        CryptoProvider.setupIfNeeded();
        if (!pkPair.getPrivate().getAlgorithm().equals(KEY_ALGO)) {
            throw new IllegalArgumentException("Keypair algorithm do not match with expected Ed25519");
        }
        this.privateKeyPair = pkPair;
        byte[] raw = this.getClearTextPublicKey();
        this.address = new Address(Arrays.copyOf(raw, raw.length));
    }

    public Account(PrivateKey pk) throws NoSuchAlgorithmException {
        CryptoProvider.setupIfNeeded();
        if (!pk.getAlgorithm().equals(KEY_ALGO)) {
            throw new IllegalArgumentException("Account cannot be generated from a non-Ed25519 key");
        }
        if (pk.getEncoded().length != 83) {
            throw new RuntimeException("Private Key cannot generate clear private key bytes");
        }
        byte[] clearPrivateKey = new byte[32];
        System.arraycopy(pk.getEncoded(), 16, clearPrivateKey, 0, 32);
        KeyPairGenerator gen = KeyPairGenerator.getInstance(KEY_ALGO);
        gen.initialize(256, (SecureRandom)new FixedSecureRandom(clearPrivateKey));
        this.privateKeyPair = gen.generateKeyPair();
        byte[] raw = this.getClearTextPublicKey();
        this.address = new Address(Arrays.copyOf(raw, raw.length));
    }

    public byte[] getClearTextPublicKey() {
        byte[] b = this.privateKeyPair.getPublic().getEncoded();
        if (b.length != 44) {
            throw new RuntimeException("Generated public key and X.509 prefix is the wrong size");
        }
        byte[] raw = new byte[32];
        System.arraycopy(b, 12, raw, 0, 32);
        return raw;
    }

    public Ed25519PublicKey getEd25519PublicKey() {
        return new Ed25519PublicKey(this.getClearTextPublicKey());
    }

    public Address getAddress() {
        return this.address;
    }

    public String toMnemonic() {
        byte[] X509enc = this.privateKeyPair.getPrivate().getEncoded();
        PrivateKeyInfo pkinfo = PrivateKeyInfo.getInstance((Object)X509enc);
        try {
            ASN1Encodable keyOcts = pkinfo.parsePrivateKey();
            byte[] res = ASN1OctetString.getInstance((Object)keyOcts).getOctets();
            return Mnemonic.fromKey(res);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected behavior", e);
        }
    }

    public SignedTransaction signTransaction(Transaction tx) throws NoSuchAlgorithmException {
        try {
            byte[] prefixEncodedTx = tx.bytesToSign();
            Signature txSig = this.rawSignBytes(Arrays.copyOf(prefixEncodedTx, prefixEncodedTx.length));
            SignedTransaction stx = new SignedTransaction(tx, txSig, tx.txID());
            if (!tx.sender.equals(this.address)) {
                stx.authAddr(this.address);
            }
            return stx;
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected behavior", e);
        }
    }

    public SignedTransaction signTransactionBytes(byte[] bytes) throws NoSuchAlgorithmException, IOException {
        try {
            Transaction tx = Encoder.decodeFromMsgPack(bytes, Transaction.class);
            return this.signTransaction(tx);
        }
        catch (IOException e) {
            throw new IOException("could not decode transaction", e);
        }
    }

    public SignedTransaction signTransactionWithFeePerByte(Transaction tx, BigInteger feePerByte) throws NoSuchAlgorithmException {
        Account.setFeeByFeePerByte(tx, feePerByte);
        return this.signTransaction(tx);
    }

    public SignedBid signBid(Bid bid) throws NoSuchAlgorithmException {
        try {
            byte[] encodedBid = Encoder.encodeToMsgPack(bid);
            byte[] prefixEncodedBid = new byte[encodedBid.length + BID_SIGN_PREFIX.length];
            System.arraycopy(BID_SIGN_PREFIX, 0, prefixEncodedBid, 0, BID_SIGN_PREFIX.length);
            System.arraycopy(encodedBid, 0, prefixEncodedBid, BID_SIGN_PREFIX.length, encodedBid.length);
            Signature bidSig = this.rawSignBytes(prefixEncodedBid);
            return new SignedBid(bid, bidSig);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected behavior", e);
        }
    }

    @Deprecated
    public static Transaction transactionWithSuggestedFeePerByte(Transaction copyTx, BigInteger suggestedFeePerByte) throws NoSuchAlgorithmException {
        BigInteger newFee = suggestedFeePerByte.multiply(Account.estimatedEncodedSize(copyTx));
        if (newFee.compareTo(MIN_TX_FEE_UALGOS) < 0) {
            newFee = MIN_TX_FEE_UALGOS;
        }
        switch (copyTx.type) {
            case Payment: {
                return new Transaction(copyTx.sender, newFee, copyTx.firstValid, copyTx.lastValid, copyTx.note, copyTx.genesisID, copyTx.genesisHash, copyTx.amount, copyTx.receiver, copyTx.closeRemainderTo);
            }
            case KeyRegistration: {
                return new Transaction(copyTx.sender, newFee, copyTx.firstValid, copyTx.lastValid, copyTx.note, copyTx.genesisID, copyTx.genesisHash, copyTx.votePK, copyTx.selectionPK, copyTx.voteFirst, copyTx.voteLast, copyTx.voteKeyDilution);
            }
            case Default: {
                throw new IllegalArgumentException("tx cannot have no type");
            }
        }
        throw new RuntimeException("cannot reach");
    }

    public static void setFeeByFeePerByte(Transaction tx, int suggestedFeePerByte) throws NoSuchAlgorithmException {
        Account.setFeeByFeePerByte(tx, BigInteger.valueOf(suggestedFeePerByte));
    }

    public static void setFeeByFeePerByte(Transaction tx, BigInteger suggestedFeePerByte) throws NoSuchAlgorithmException {
        if (suggestedFeePerByte.compareTo(BigInteger.ZERO) < 0) {
            throw new RuntimeException("Cannot set fee to a negative number.");
        }
        tx.fee = suggestedFeePerByte;
        BigInteger size = Account.estimatedEncodedSize(tx);
        BigInteger fee = suggestedFeePerByte.multiply(size);
        if (fee.compareTo(MIN_TX_FEE_UALGOS) < 0) {
            fee = MIN_TX_FEE_UALGOS;
        }
        tx.setFee(fee);
    }

    public static BigInteger estimatedEncodedSize(Transaction tx) throws NoSuchAlgorithmException {
        try {
            long length = Encoder.encodeToMsgPack(new SignedTransaction(tx, new Account().rawSignBytes(Arrays.copyOf(tx.bytesToSign(), tx.bytesToSign().length)), tx.txID())).length;
            return BigInteger.valueOf(length);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected behavior", e);
        }
    }

    private Signature rawSignBytes(byte[] bytes) throws NoSuchAlgorithmException {
        try {
            CryptoProvider.setupIfNeeded();
            java.security.Signature signer = java.security.Signature.getInstance(SIGN_ALGO);
            signer.initSign(this.privateKeyPair.getPrivate());
            signer.update(bytes);
            byte[] sigRaw = signer.sign();
            return new Signature(sigRaw);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException("unexpected behavior", e);
        }
    }

    public Signature signBytes(byte[] bytes) throws NoSuchAlgorithmException {
        byte[] prefixBytes = new byte[bytes.length + BYTES_SIGN_PREFIX.length];
        System.arraycopy(BYTES_SIGN_PREFIX, 0, prefixBytes, 0, BYTES_SIGN_PREFIX.length);
        System.arraycopy(bytes, 0, prefixBytes, BYTES_SIGN_PREFIX.length, bytes.length);
        return this.rawSignBytes(prefixBytes);
    }

    public SignedTransaction signMultisigTransaction(MultisigAddress from, Transaction tx) throws NoSuchAlgorithmException {
        Ed25519PublicKey myPK = this.getEd25519PublicKey();
        int myI = from.publicKeys.indexOf(myPK);
        if (myI == -1) {
            throw new IllegalArgumentException("Multisig account does not contain this secret key");
        }
        SignedTransaction txSig = this.signTransaction(tx);
        MultisigSignature mSig = new MultisigSignature(from.version, from.threshold);
        for (int i = 0; i < from.publicKeys.size(); ++i) {
            if (i == myI) {
                mSig.subsigs.add(new MultisigSignature.MultisigSubsig(myPK, txSig.sig));
                continue;
            }
            mSig.subsigs.add(new MultisigSignature.MultisigSubsig(from.publicKeys.get(i)));
        }
        SignedTransaction stx = new SignedTransaction(tx, mSig, txSig.transactionID);
        if (!tx.sender.equals(from.toAddress())) {
            stx.authAddr = from.toAddress();
        }
        return stx;
    }

    public static SignedTransaction mergeMultisigTransactions(SignedTransaction ... txs) {
        if (txs.length < 2) {
            throw new IllegalArgumentException("cannot merge a single transaction");
        }
        SignedTransaction merged = txs[0];
        for (SignedTransaction tx : txs) {
            if (tx.mSig.version != merged.mSig.version || tx.mSig.threshold != merged.mSig.threshold) {
                throw new IllegalArgumentException("transaction msig parameters do not match");
            }
            if (!tx.mSig.convertToMultisigAddress().equals(merged.mSig.convertToMultisigAddress())) {
                throw new IllegalArgumentException("transaction msig addresses do not match");
            }
            if (!tx.authAddr.equals(merged.authAddr)) {
                throw new IllegalArgumentException("transaction msig auth addr do not match");
            }
            for (int j = 0; j < tx.mSig.subsigs.size(); ++j) {
                MultisigSignature.MultisigSubsig myMsig = merged.mSig.subsigs.get(j);
                MultisigSignature.MultisigSubsig theirMsig = tx.mSig.subsigs.get(j);
                if (!theirMsig.key.equals(myMsig.key)) {
                    throw new IllegalArgumentException("transaction msig public keys do not match");
                }
                if (myMsig.sig.equals(new Signature())) {
                    myMsig.sig = theirMsig.sig;
                } else if (!myMsig.sig.equals(theirMsig.sig) && !theirMsig.sig.equals(new Signature())) {
                    throw new IllegalArgumentException("transaction msig has mismatched signatures");
                }
                merged.mSig.subsigs.set(j, myMsig);
            }
        }
        return merged;
    }

    public SignedTransaction appendMultisigTransaction(MultisigAddress from, SignedTransaction signedTx) throws NoSuchAlgorithmException {
        SignedTransaction sTx = this.signMultisigTransaction(from, signedTx.tx);
        return Account.mergeMultisigTransactions(sTx, signedTx);
    }

    public static byte[] mergeMultisigTransactionBytes(byte[] ... txsBytes) throws NoSuchAlgorithmException, IOException {
        try {
            SignedTransaction[] sTxs = new SignedTransaction[txsBytes.length];
            for (int i = 0; i < txsBytes.length; ++i) {
                sTxs[i] = Encoder.decodeFromMsgPack(txsBytes[i], SignedTransaction.class);
            }
            SignedTransaction merged = Account.mergeMultisigTransactions(sTxs);
            return Encoder.encodeToMsgPack(merged);
        }
        catch (IOException e) {
            throw new IOException("could not decode transactions", e);
        }
    }

    public byte[] appendMultisigTransactionBytes(MultisigAddress from, byte[] txBytes) throws NoSuchAlgorithmException, IOException {
        try {
            SignedTransaction inTx = Encoder.decodeFromMsgPack(txBytes, SignedTransaction.class);
            SignedTransaction appended = this.appendMultisigTransaction(from, inTx);
            return Encoder.encodeToMsgPack(appended);
        }
        catch (IOException e) {
            throw new IOException("could not decode transactions", e);
        }
    }

    public byte[] signMultisigTransactionBytes(MultisigAddress from, Transaction tx) throws NoSuchAlgorithmException, IOException {
        try {
            SignedTransaction signed = this.signMultisigTransaction(from, tx);
            return Encoder.encodeToMsgPack(signed);
        }
        catch (IOException e) {
            throw new IOException("could not encode transactions", e);
        }
    }

    public LogicsigSignature signLogicsig(LogicsigSignature lsig) throws IOException {
        Signature sig;
        try {
            byte[] bytesToSign = lsig.bytesToSign();
            sig = this.rawSignBytes(bytesToSign);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("could not sign transaction", ex);
        }
        lsig.sig = sig;
        return lsig;
    }

    public LogicsigSignature signLogicsig(LogicsigSignature lsig, MultisigAddress ma) throws IOException {
        Signature sig;
        Ed25519PublicKey myPK = this.getEd25519PublicKey();
        int myIndex = ma.publicKeys.indexOf(myPK);
        if (myIndex == -1) {
            throw new IllegalArgumentException("Multisig account does not contain this secret key");
        }
        try {
            byte[] bytesToSign = lsig.bytesToSign();
            sig = this.rawSignBytes(bytesToSign);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("could not sign transaction", ex);
        }
        MultisigSignature mSig = new MultisigSignature(ma.version, ma.threshold);
        for (int i = 0; i < ma.publicKeys.size(); ++i) {
            if (i == myIndex) {
                mSig.subsigs.add(new MultisigSignature.MultisigSubsig(myPK, sig));
                continue;
            }
            mSig.subsigs.add(new MultisigSignature.MultisigSubsig(ma.publicKeys.get(i)));
        }
        lsig.msig = mSig;
        return lsig;
    }

    public LogicsigSignature appendToLogicsig(LogicsigSignature lsig) throws IllegalArgumentException, IOException {
        Ed25519PublicKey myPK = this.getEd25519PublicKey();
        int myIndex = -1;
        for (int i = 0; i < lsig.msig.subsigs.size(); ++i) {
            MultisigSignature.MultisigSubsig subsig = lsig.msig.subsigs.get(i);
            if (!subsig.key.equals(myPK)) continue;
            myIndex = i;
        }
        if (myIndex == -1) {
            throw new IllegalArgumentException("Multisig account does not contain this secret key");
        }
        try {
            byte[] bytesToSign = lsig.bytesToSign();
            Signature sig = this.rawSignBytes(bytesToSign);
            lsig.msig.subsigs.set(myIndex, new MultisigSignature.MultisigSubsig(myPK, sig));
            return lsig;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("could not sign transaction", ex);
        }
    }

    public static SignedTransaction signLogicTransactionWithAddress(LogicsigSignature lsig, Address lsigAddr, Transaction tx) throws IllegalArgumentException, IOException {
        try {
            if (!lsig.verify(lsigAddr)) {
                throw new IllegalArgumentException("verification failed on logic sig");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("verification failed on logic sig", ex);
        }
        try {
            SignedTransaction stx = new SignedTransaction(tx, lsig, tx.txID());
            if (!stx.tx.sender.equals(lsigAddr)) {
                stx.authAddr = lsigAddr;
            }
            return stx;
        }
        catch (Exception ex) {
            throw new IOException("could not encode transactions", ex);
        }
    }

    public static SignedTransaction signLogicsigTransaction(LogicsigSignature lsig, Transaction tx) throws IllegalArgumentException, IOException {
        boolean hasSig = lsig.sig != null;
        boolean hasMsig = lsig.msig != null;
        try {
            Address lsigAddr = hasSig ? tx.sender : (hasMsig ? lsig.msig.convertToMultisigAddress().toAddress() : lsig.toAddress());
            return Account.signLogicTransactionWithAddress(lsig, lsigAddr, tx);
        }
        catch (Exception ex) {
            throw new IOException("could not sign transaction", ex);
        }
    }

    public Signature tealSign(byte[] data, Address contractAddress) throws NoSuchAlgorithmException, IOException {
        byte[] rawAddress = contractAddress.getBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(PROGDATA_SIGN_PREFIX);
        baos.write(rawAddress);
        baos.write(data);
        return this.rawSignBytes(baos.toByteArray());
    }

    public Signature tealSignFromProgram(byte[] data, byte[] program) throws NoSuchAlgorithmException, IOException {
        LogicsigSignature lsig = new LogicsigSignature(program);
        return this.tealSign(data, lsig.toAddress());
    }

    public byte[] toSeed() throws GeneralSecurityException {
        String mnemonic = this.toMnemonic();
        return Mnemonic.toKey(mnemonic);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Account)) {
            return false;
        }
        Account oAccount = (Account)obj;
        boolean addressMatch = Arrays.equals(this.address.getBytes(), oAccount.address.getBytes());
        boolean privateKeyMatch = Arrays.equals(this.privateKeyPair.getPrivate().getEncoded(), oAccount.privateKeyPair.getPrivate().getEncoded());
        boolean publicKeyMatch = Arrays.equals(this.privateKeyPair.getPublic().getEncoded(), oAccount.privateKeyPair.getPublic().getEncoded());
        return addressMatch && privateKeyMatch && publicKeyMatch;
    }

    public TxnSigner getTransactionSigner() {
        final Account self = this;
        return new TxnSigner(){

            public int hashCode() {
                return Objects.hash(1, self);
            }

            @Override
            public SignedTransaction[] signTxnGroup(Transaction[] txnGroup, int[] indicesToSign) throws Exception {
                SignedTransaction[] sTxn = new SignedTransaction[indicesToSign.length];
                for (int i = 0; i < indicesToSign.length; ++i) {
                    sTxn[i] = self.signTransaction(txnGroup[indicesToSign[i]]);
                }
                return sTxn;
            }
        };
    }

    public static class FixedSecureRandom
    extends SecureRandom {
        private final byte[] fixedValue;
        private int index = 0;

        public FixedSecureRandom(byte[] fixedValue) {
            this.fixedValue = Arrays.copyOf(fixedValue, fixedValue.length);
        }

        @Override
        public void nextBytes(byte[] bytes) {
            if (this.index >= this.fixedValue.length) {
                return;
            }
            int len = bytes.length;
            if (len > this.fixedValue.length - this.index) {
                len = this.fixedValue.length - this.index;
            }
            System.arraycopy(this.fixedValue, this.index, bytes, 0, len);
            this.index += bytes.length;
        }

        @Override
        public byte[] generateSeed(int numBytes) {
            byte[] bytes = new byte[numBytes];
            this.nextBytes(bytes);
            return bytes;
        }
    }
}

