/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.abi;

import com.algorand.algosdk.abi.ABIType;
import com.algorand.algosdk.util.Encoder;
import java.math.BigInteger;

public class TypeUint
extends ABIType {
    public final int bitSize;

    public TypeUint(int size) {
        if (size < 8 || size > 512 || size % 8 != 0) {
            throw new IllegalArgumentException("uint initialize failure: bitSize should be in [8, 512] and bitSize mod 8 == 0");
        }
        this.bitSize = size;
    }

    public String toString() {
        return "uint" + this.bitSize;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TypeUint)) {
            return false;
        }
        return this.bitSize == ((TypeUint)o).bitSize;
    }

    @Override
    public byte[] encode(Object obj) {
        BigInteger value;
        if (obj instanceof BigInteger) {
            value = (BigInteger)obj;
        } else if (obj instanceof Short) {
            value = BigInteger.valueOf(((Short)obj).shortValue());
        } else if (obj instanceof Integer) {
            value = BigInteger.valueOf(((Integer)obj).intValue());
        } else if (obj instanceof Long) {
            value = BigInteger.valueOf((Long)obj);
        } else if (obj instanceof Byte) {
            value = BigInteger.valueOf(((Byte)obj).byteValue());
        } else {
            throw new IllegalArgumentException("cannot infer type for uint value encode");
        }
        return Encoder.encodeUintToBytes(value, this.bitSize / 8);
    }

    @Override
    public Object decode(byte[] encoded) {
        if (encoded.length != this.bitSize / 8) {
            throw new IllegalArgumentException("cannot decode for abi uint value, byte length not matching");
        }
        return Encoder.decodeBytesToUint(encoded);
    }

    @Override
    public int byteLen() {
        return this.bitSize / 8;
    }
}

