/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.abi;

import com.algorand.algosdk.abi.ABIType;
import com.algorand.algosdk.util.Encoder;
import java.math.BigInteger;

public class TypeUfixed
extends ABIType {
    public final int bitSize;
    public final int precision;

    public TypeUfixed(int size, int precision) {
        if (size < 8 || size > 512 || size % 8 != 0) {
            throw new IllegalArgumentException("ufixed initialize failure: bitSize should be in [8, 512] and bitSize mod 8 == 0");
        }
        if (precision < 1 || precision > 160) {
            throw new IllegalArgumentException("ufixed initialize failure: precision should be in [1, 160]");
        }
        this.bitSize = size;
        this.precision = precision;
    }

    public String toString() {
        return "ufixed" + this.bitSize + "x" + this.precision;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TypeUfixed)) {
            return false;
        }
        return this.bitSize == ((TypeUfixed)o).bitSize && this.precision == ((TypeUfixed)o).precision;
    }

    @Override
    public byte[] encode(Object obj) {
        BigInteger value;
        if (obj instanceof BigInteger) {
            value = (BigInteger)obj;
        } else if (obj instanceof Short) {
            value = BigInteger.valueOf(((Short)obj).shortValue());
        } else if (obj instanceof Integer) {
            value = BigInteger.valueOf(((Integer)obj).intValue());
        } else if (obj instanceof Long) {
            value = BigInteger.valueOf((Long)obj);
        } else if (obj instanceof Byte) {
            value = BigInteger.valueOf(((Byte)obj).byteValue());
        } else {
            throw new IllegalArgumentException("cannot infer type for ufixed value encode");
        }
        return Encoder.encodeUintToBytes(value, this.bitSize / 8);
    }

    @Override
    public Object decode(byte[] encoded) {
        if (encoded.length != this.bitSize / 8) {
            throw new IllegalArgumentException("cannot decode for abi ufixed value, byte length not matching");
        }
        return Encoder.decodeBytesToUint(encoded);
    }

    @Override
    public int byteLen() {
        return this.bitSize / 8;
    }
}

