/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.abi;

import com.algorand.algosdk.abi.ABIType;
import com.algorand.algosdk.abi.TypeByte;
import com.algorand.algosdk.util.Encoder;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ArrayUtils;

public class TypeString
extends ABIType {
    public String toString() {
        return "string";
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TypeString;
    }

    @Override
    public byte[] encode(Object o) {
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("cannot infer type for abi string encode");
        }
        byte[] buffer = ((String)o).getBytes(StandardCharsets.UTF_8);
        if (buffer.length >= 65536) {
            throw new IllegalArgumentException("string casted to byte exceeds uint16 maximum, error");
        }
        byte[] lengthEncode = Encoder.encodeUintToBytes(BigInteger.valueOf(buffer.length), 2);
        byte[] castedBytes = ABIType.castToTupleType(buffer.length, new TypeByte()).encode(ArrayUtils.toObject((byte[])buffer));
        ByteBuffer bf = ByteBuffer.allocate(castedBytes.length + 2);
        bf.put(lengthEncode);
        bf.put(castedBytes);
        return bf.array();
    }

    @Override
    public Object decode(byte[] encoded) {
        byte[] encodedLength = ABIType.getLengthEncoded(encoded);
        byte[] encodedString = ABIType.getContentEncoded(encoded);
        if (!Encoder.decodeBytesToUint(encodedLength).equals(BigInteger.valueOf(encodedString.length))) {
            throw new IllegalArgumentException("string decode failure: encoded bytes do not match with length header");
        }
        return new String(encodedString, StandardCharsets.UTF_8);
    }

    @Override
    public int byteLen() {
        throw new IllegalArgumentException("Dynamic type cannot pre-compute byteLen");
    }
}

