/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.abi;

import com.algorand.algosdk.abi.ABIType;

public class TypeBool
extends ABIType {
    public String toString() {
        return "bool";
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TypeBool;
    }

    @Override
    public byte[] encode(Object o) {
        if (!(o instanceof Boolean)) {
            throw new IllegalArgumentException("cannot infer type for boolean abi value encode");
        }
        boolean res = (Boolean)o;
        return new byte[]{res ? (byte)-128 : 0};
    }

    @Override
    public Object decode(byte[] encoded) {
        if (encoded.length != 1) {
            throw new IllegalArgumentException("cannot decode abi bool value, byte length do not match");
        }
        if (encoded[0] == -128) {
            return true;
        }
        if (encoded[0] == 0) {
            return false;
        }
        throw new IllegalArgumentException("cannot decode abi bool value, illegal encoding value");
    }

    @Override
    public int byteLen() {
        return 1;
    }
}

