/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.abi;

import com.algorand.algosdk.abi.ABIType;
import com.algorand.algosdk.transaction.Transaction;
import com.algorand.algosdk.util.CryptoProvider;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Method {
    @JsonIgnore
    public static final String TxAnyType = "txn";
    @JsonIgnore
    public static final Set<String> TxArgTypes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("txn", Transaction.Type.Payment.toValue(), Transaction.Type.KeyRegistration.toValue(), Transaction.Type.AssetConfig.toValue(), Transaction.Type.AssetTransfer.toValue(), Transaction.Type.AssetFreeze.toValue(), Transaction.Type.ApplicationCall.toValue())));
    @JsonIgnore
    public static final String RefTypeAccount = "account";
    @JsonIgnore
    public static final String RefTypeAsset = "asset";
    @JsonIgnore
    public static final String RefTypeApplication = "application";
    @JsonIgnore
    public static final Set<String> RefArgTypes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("account", "asset", "application")));
    @JsonIgnore
    private static final String HASH_ALG = "SHA-512/256";
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="desc")
    public String desc;
    @JsonProperty(value="args")
    public List<Arg> args = new ArrayList<Arg>();
    @JsonProperty(value="returns")
    public Returns returns = new Returns("void", null);
    @JsonIgnore
    private int txnCallCount = 1;

    static boolean isTxnArgOrForeignArrayArgs(String str) {
        return TxArgTypes.contains(str) || RefArgTypes.contains(str);
    }

    @JsonCreator
    public Method(@JsonProperty(value="name") String name, @JsonProperty(value="desc") String desc, @JsonProperty(value="args") List<Arg> args, @JsonProperty(value="returns") Returns returns) {
        this.name = Method.nameChecker(name);
        this.desc = desc;
        if (args != null) {
            this.args = args;
        }
        if (returns != null) {
            this.returns = returns;
        }
        for (Arg arg : this.args) {
            if (!TxArgTypes.contains(arg.type)) continue;
            ++this.txnCallCount;
        }
    }

    public Method(Method other) {
        this.name = other.name;
        this.desc = other.desc;
        this.returns = new Returns(other.returns);
        for (Arg oArgs : other.args) {
            this.args.add(new Arg(oArgs));
        }
        this.txnCallCount = other.txnCallCount;
    }

    private static String nameChecker(String name) {
        String nameStr = Objects.requireNonNull(name, "name must not be null");
        if (nameStr.isEmpty()) {
            throw new IllegalArgumentException("name must not be an empty string");
        }
        return nameStr;
    }

    public Method(String method) {
        List<String> parsedMethod = Method.methodParse(method);
        this.name = Method.nameChecker(parsedMethod.get(0));
        this.args = new ArrayList<Arg>();
        List<String> parsedMethodArgs = ABIType.parseTupleContent(parsedMethod.get(1));
        for (String parsedMethodArg : parsedMethodArgs) {
            this.args.add(new Arg(null, parsedMethodArg, null));
        }
        for (Arg arg : this.args) {
            if (!TxArgTypes.contains(arg.type)) continue;
            ++this.txnCallCount;
        }
        this.returns = new Returns(parsedMethod.get(2), null);
    }

    private static List<String> methodParse(String method) {
        ArrayDeque<Integer> parenStack = new ArrayDeque<Integer>();
        for (int i = 0; i < method.length(); ++i) {
            if (method.charAt(i) == '(') {
                parenStack.push(i);
                continue;
            }
            if (method.charAt(i) != ')') continue;
            if (parenStack.isEmpty()) break;
            int leftParenIndex = (Integer)parenStack.pop();
            if (parenStack.size() > 0) continue;
            ArrayList<String> res = new ArrayList<String>();
            res.add(method.substring(0, leftParenIndex));
            if (leftParenIndex + 1 == i) {
                res.add("");
            } else {
                res.add(method.substring(leftParenIndex + 1, i));
            }
            res.add(method.substring(i + 1));
            return res;
        }
        throw new IllegalArgumentException("method string parentheses unbalanced: " + method);
    }

    @JsonIgnore
    public String getSignature() {
        ArrayList<String> argStringList = new ArrayList<String>();
        for (Arg value : this.args) {
            argStringList.add(value.type);
        }
        return this.name + "(" + StringUtils.join((Object[])argStringList.toArray(new String[0]), (String)",") + ")" + this.returns.type;
    }

    @JsonIgnore
    public byte[] getSelector() {
        try {
            CryptoProvider.setupIfNeeded();
            MessageDigest digest = MessageDigest.getInstance(HASH_ALG);
            String method = this.getSignature();
            digest.update(method.getBytes(StandardCharsets.UTF_8));
            byte[] d = digest.digest();
            return Arrays.copyOfRange(d, 0, 4);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnore
    public int getTxnCallCount() {
        return this.txnCallCount;
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        return Objects.equals(this.name, method.name) && Objects.equals(this.desc, method.desc) && Objects.equals(this.args, method.args) && Objects.equals(this.returns, method.returns);
    }

    @JsonIgnore
    public static Method getMethodByName(List<Method> methods, String name) {
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        for (Method m : methods) {
            if (!m.name.equals(name)) continue;
            filteredMethods.add(m);
        }
        if (filteredMethods.size() > 1) {
            Object[] sigs = new String[filteredMethods.size()];
            for (int idx = 0; idx < filteredMethods.size(); ++idx) {
                sigs[idx] = ((Method)filteredMethods.get(idx)).getSignature();
            }
            String found = StringUtils.join((Object[])sigs, (String)",");
            throw new IllegalArgumentException(String.format("found %d methods with the same name: %s", filteredMethods.size(), found));
        }
        if (filteredMethods.size() == 0) {
            throw new IllegalArgumentException(String.format("found 0 methods with the name %s", name));
        }
        return (Method)filteredMethods.get(0);
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class Returns {
        @JsonIgnore
        public static final String VoidRetType = "void";
        @JsonProperty(value="type")
        public String type;
        @JsonProperty(value="desc")
        public String desc;
        @JsonIgnore
        public ABIType parsedType;

        @JsonCreator
        public Returns(@JsonProperty(value="type") String type, @JsonProperty(value="desc") String desc) {
            String typeStr = Objects.requireNonNull(type, "type must not be null");
            this.parsedType = typeStr.equals(VoidRetType) ? null : ABIType.valueOf(typeStr);
            this.type = typeStr;
            this.desc = desc;
        }

        public Returns(Returns otherRet) {
            this(otherRet.type, otherRet.desc);
            this.parsedType = otherRet.parsedType;
        }

        public boolean equals(Object o) {
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Returns returns = (Returns)o;
            return Objects.equals(this.type, returns.type) && Objects.equals(this.desc, returns.desc);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class Arg {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="type")
        public String type;
        @JsonProperty(value="desc")
        public String desc;
        @JsonIgnore
        public ABIType parsedType;

        @JsonCreator
        public Arg(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="desc") String desc) {
            this.name = name;
            this.desc = desc;
            String typeStr = Objects.requireNonNull(type, "type must not be null");
            this.parsedType = Method.isTxnArgOrForeignArrayArgs(typeStr) ? null : ABIType.valueOf(typeStr);
            this.type = typeStr;
        }

        public Arg(Arg otherArg) {
            this(otherArg.name, otherArg.type, otherArg.desc);
            this.parsedType = otherArg.parsedType;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Arg arg = (Arg)o;
            return Objects.equals(this.name, arg.name) && Objects.equals(this.type, arg.type) && Objects.equals(this.desc, arg.desc);
        }
    }
}

