/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.abi;

import com.algorand.algosdk.abi.Method;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Interface {
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="desc")
    public String description;
    @JsonProperty(value="methods")
    public List<Method> methods = new ArrayList<Method>();

    @JsonCreator
    public Interface(@JsonProperty(value="name") String name, @JsonProperty(value="desc") String description, @JsonProperty(value="methods") List<Method> methods) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.description = description;
        if (methods != null) {
            this.methods = methods;
        }
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public Method getMethodByIndex(int index) {
        return this.methods.get(index);
    }

    @JsonIgnore
    public Method getMethodByName(String name) {
        return Method.getMethodByName(this.methods, name);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interface that = (Interface)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.methods, that.methods);
    }
}

