/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.abi;

import com.algorand.algosdk.abi.Method;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Contract {
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="desc")
    public String description;
    @JsonProperty(value="networks")
    public Map<String, NetworkInfo> networks = new HashMap<String, NetworkInfo>();
    @JsonProperty(value="methods")
    public List<Method> methods = new ArrayList<Method>();

    @JsonCreator
    public Contract(@JsonProperty(value="name") String name, @JsonProperty(value="desc") String description, @JsonProperty(value="networks") Map<String, NetworkInfo> networks, @JsonProperty(value="methods") List<Method> methods) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.description = description;
        if (networks != null) {
            this.networks = networks;
        }
        if (methods != null) {
            this.methods = methods;
        }
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public NetworkInfo getNetworkInfo(String genesisHash) {
        return this.networks.get(genesisHash);
    }

    @JsonIgnore
    public Method getMethodByIndex(int index) {
        return this.methods.get(index);
    }

    @JsonIgnore
    public Method getMethodByName(String name) {
        return Method.getMethodByName(this.methods, name);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contract contract = (Contract)o;
        return Objects.equals(this.name, contract.name) && Objects.equals(this.methods, contract.methods) && Objects.equals(this.description, contract.description) && Objects.equals(this.networks, contract.networks);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class NetworkInfo {
        @JsonProperty(value="appID")
        public Long appID;

        @JsonCreator
        public NetworkInfo(@JsonProperty(value="appID") Long appID) {
            this.appID = Objects.requireNonNull(appID, "appID must not be null");
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            NetworkInfo other = (NetworkInfo)o;
            return Objects.equals(this.appID, other.appID);
        }
    }
}

