/*
 * Decompiled with CFR 0.152.
 */
package com.algorand.algosdk.abi;

import com.algorand.algosdk.abi.TypeAddress;
import com.algorand.algosdk.abi.TypeArrayDynamic;
import com.algorand.algosdk.abi.TypeArrayStatic;
import com.algorand.algosdk.abi.TypeBool;
import com.algorand.algosdk.abi.TypeByte;
import com.algorand.algosdk.abi.TypeString;
import com.algorand.algosdk.abi.TypeTuple;
import com.algorand.algosdk.abi.TypeUfixed;
import com.algorand.algosdk.abi.TypeUint;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ABIType {
    public static final int ABI_DYNAMIC_HEAD_BYTE_LEN = 2;
    private static final Pattern staticArrayPattern = Pattern.compile("^(?<elemT>[a-z\\d\\[\\](),]+)\\[(?<len>[1-9][\\d]*)]$");
    private static final Pattern ufixedPattern = Pattern.compile("^ufixed(?<size>[1-9][\\d]*)x(?<precision>[1-9][\\d]*)$");

    public abstract boolean isDynamic();

    public abstract boolean equals(Object var1);

    public abstract int byteLen();

    public abstract byte[] encode(Object var1);

    public abstract Object decode(byte[] var1);

    public static ABIType valueOf(String str) {
        if (str.endsWith("[]")) {
            ABIType elemType = ABIType.valueOf(str.substring(0, str.length() - 2));
            return new TypeArrayDynamic(elemType);
        }
        if (str.endsWith("]")) {
            Matcher m = staticArrayPattern.matcher(str);
            if (!m.matches()) {
                throw new IllegalArgumentException("static array type ill format: " + str);
            }
            ABIType elemT = ABIType.valueOf(m.group("elemT"));
            int length = Integer.parseInt(m.group("len"));
            return new TypeArrayStatic(elemT, length);
        }
        if (str.startsWith("uint")) {
            int size = Integer.parseInt(str.substring(4));
            return new TypeUint(size);
        }
        if (str.equals("byte")) {
            return new TypeByte();
        }
        if (str.startsWith("ufixed")) {
            Matcher m = ufixedPattern.matcher(str);
            if (!m.matches()) {
                throw new IllegalArgumentException("ufixed type ill format: " + str);
            }
            int size = Integer.parseInt(m.group("size"));
            int precision = Integer.parseInt(m.group("precision"));
            return new TypeUfixed(size, precision);
        }
        if (str.equals("bool")) {
            return new TypeBool();
        }
        if (str.equals("address")) {
            return new TypeAddress();
        }
        if (str.equals("string")) {
            return new TypeString();
        }
        if (str.length() >= 2 && str.charAt(0) == '(' && str.endsWith(")")) {
            List<String> tupleContent = ABIType.parseTupleContent(str.substring(1, str.length() - 1));
            ArrayList<ABIType> tupleTypes = new ArrayList<ABIType>();
            for (String subStr : tupleContent) {
                tupleTypes.add(ABIType.valueOf(subStr));
            }
            return new TypeTuple(tupleTypes);
        }
        throw new IllegalArgumentException("Cannot infer type from the string: " + str);
    }

    public static List<String> parseTupleContent(String str) {
        if (str.length() == 0) {
            return new ArrayList<String>();
        }
        if (str.startsWith(",") || str.endsWith(",")) {
            throw new IllegalArgumentException("parsing error: tuple content should not start with comma");
        }
        if (str.contains(",,")) {
            throw new IllegalArgumentException("parsing error: tuple content should not have consecutive commas");
        }
        ArrayDeque<Integer> parenStack = new ArrayDeque<Integer>();
        ArrayList<Segment> parenSegments = new ArrayList<Segment>();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '(') {
                parenStack.push(i);
                continue;
            }
            if (str.charAt(i) != ')') continue;
            if (parenStack.isEmpty()) {
                throw new IllegalArgumentException("parsing error: tuple parentheses are not balanced: " + str);
            }
            int leftParenIndex = (Integer)parenStack.pop();
            if (!parenStack.isEmpty()) continue;
            parenSegments.add(new Segment(leftParenIndex, i));
        }
        if (!parenStack.isEmpty()) {
            throw new IllegalArgumentException("parsing error: tuple parentheses are not balanced: " + str);
        }
        String strCopied = str;
        for (int i = parenSegments.size() - 1; i >= 0; --i) {
            strCopied = strCopied.substring(0, ((Segment)parenSegments.get((int)i)).L) + strCopied.substring(((Segment)parenSegments.get((int)i)).R + 1);
        }
        String[] tupleSeg = strCopied.split(",", -1);
        int parenSegCount = 0;
        for (int i = 0; i < tupleSeg.length; ++i) {
            if (!tupleSeg[i].isEmpty()) continue;
            tupleSeg[i] = str.substring(((Segment)parenSegments.get((int)parenSegCount)).L, ((Segment)parenSegments.get((int)parenSegCount)).R + 1);
            ++parenSegCount;
        }
        return Arrays.asList(tupleSeg);
    }

    protected static int findBoolLR(ABIType[] typeArray, int index, int delta) {
        int until;
        block3: {
            int currentIndex;
            until = 0;
            while (typeArray[currentIndex = index + delta * until] instanceof TypeBool) {
                if (currentIndex != typeArray.length - 1 && delta > 0) {
                    ++until;
                    continue;
                }
                if (currentIndex != 0 && delta < 0) {
                    ++until;
                    continue;
                }
                break block3;
            }
            --until;
        }
        return until;
    }

    protected static byte[] getLengthEncoded(byte[] encoded) {
        if (encoded.length < 2) {
            throw new IllegalArgumentException("encode byte size too small, less than 2 bytes");
        }
        byte[] encodedLength = new byte[2];
        System.arraycopy(encoded, 0, encodedLength, 0, 2);
        return encodedLength;
    }

    protected static byte[] getContentEncoded(byte[] encoded) {
        if (encoded.length < 2) {
            throw new IllegalArgumentException("encode byte size too small, less than 2 bytes");
        }
        byte[] encodedString = new byte[encoded.length - 2];
        System.arraycopy(encoded, 2, encodedString, 0, encoded.length - 2);
        return encodedString;
    }

    protected static TypeTuple castToTupleType(int size, ABIType t) {
        ArrayList<ABIType> tupleTypes = new ArrayList<ABIType>();
        for (int i = 0; i < size; ++i) {
            tupleTypes.add(t);
        }
        return new TypeTuple(tupleTypes);
    }

    private static class Segment {
        public int L;
        public int R;

        Segment(int left, int right) {
            this.L = left;
            this.R = right;
        }
    }
}

