/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgegrid.signer;

import com.akamai.edgegrid.signer.ClientCredential;
import com.akamai.edgegrid.signer.ClientCredentialProvider;
import com.akamai.edgegrid.signer.DefaultClientCredentialProvider;
import com.akamai.edgegrid.signer.EdgeGridV1Signer;
import com.akamai.edgegrid.signer.Request;
import com.akamai.edgegrid.signer.exceptions.NoMatchingCredentialException;
import com.akamai.edgegrid.signer.exceptions.RequestSigningException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public abstract class AbstractEdgeGridRequestSigner<RequestT, MutableRequestT> {
    private final ClientCredentialProvider clientCredentialProvider;
    private final EdgeGridV1Signer edgeGridSigner;

    public AbstractEdgeGridRequestSigner(ClientCredential clientCredential) {
        this(new DefaultClientCredentialProvider(clientCredential));
    }

    public AbstractEdgeGridRequestSigner(ClientCredentialProvider clientCredentialProvider) {
        this.clientCredentialProvider = clientCredentialProvider;
        this.edgeGridSigner = new EdgeGridV1Signer();
    }

    public final ClientCredentialProvider getClientCredentialProvider() {
        return this.clientCredentialProvider;
    }

    public void sign(RequestT request, MutableRequestT requestToUpdate) throws RequestSigningException {
        Request req = this.map(request);
        ClientCredential credential = this.clientCredentialProvider.getClientCredential(req);
        if (credential == null) {
            throw new NoMatchingCredentialException();
        }
        String newHost = credential.getHost();
        URI originalUri = Objects.requireNonNull(this.requestUri(request), "Request-URI cannot be null");
        URI newUri = this.withNewHost(originalUri, newHost);
        this.setHost(requestToUpdate, newHost, newUri);
        String authorization = this.edgeGridSigner.getSignature(req, credential);
        this.setAuthorization(requestToUpdate, authorization);
    }

    protected abstract URI requestUri(RequestT var1);

    protected abstract Request map(RequestT var1);

    protected abstract void setAuthorization(MutableRequestT var1, String var2);

    protected abstract void setHost(MutableRequestT var1, String var2, URI var3);

    private URI withNewHost(URI uri, String host) {
        String[] hostAndPort = host.split(":");
        String hostName = hostAndPort[0];
        int port = hostAndPort.length == 2 ? Integer.parseInt(hostAndPort[1]) : uri.getPort();
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), hostName, port, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

