/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Amount;
import com.adyen.model.payout.FraudResult;
import com.adyen.model.payout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "authCode", "dccAmount", "dccSignature", "fraudResult", "issuerUrl", "md", "paRequest", "pspReference", "refusalReason", "resultCode"})
public class PayoutResponse {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_AUTH_CODE = "authCode";
    private String authCode;
    public static final String JSON_PROPERTY_DCC_AMOUNT = "dccAmount";
    private Amount dccAmount;
    public static final String JSON_PROPERTY_DCC_SIGNATURE = "dccSignature";
    private String dccSignature;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    public static final String JSON_PROPERTY_ISSUER_URL = "issuerUrl";
    private String issuerUrl;
    public static final String JSON_PROPERTY_MD = "md";
    private String md;
    public static final String JSON_PROPERTY_PA_REQUEST = "paRequest";
    private String paRequest;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;

    public PayoutResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PayoutResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PayoutResponse authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthCode() {
        return this.authCode;
    }

    @JsonProperty(value="authCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public PayoutResponse dccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
        return this;
    }

    @JsonProperty(value="dccAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getDccAmount() {
        return this.dccAmount;
    }

    @JsonProperty(value="dccAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
    }

    public PayoutResponse dccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
        return this;
    }

    @JsonProperty(value="dccSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDccSignature() {
        return this.dccSignature;
    }

    @JsonProperty(value="dccSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
    }

    public PayoutResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public PayoutResponse issuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @JsonProperty(value="issuerUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public PayoutResponse md(String md) {
        this.md = md;
        return this;
    }

    @JsonProperty(value="md")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMd() {
        return this.md;
    }

    @JsonProperty(value="md")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMd(String md) {
        this.md = md;
    }

    public PayoutResponse paRequest(String paRequest) {
        this.paRequest = paRequest;
        return this;
    }

    @JsonProperty(value="paRequest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaRequest() {
        return this.paRequest;
    }

    @JsonProperty(value="paRequest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaRequest(String paRequest) {
        this.paRequest = paRequest;
    }

    public PayoutResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PayoutResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PayoutResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutResponse payoutResponse = (PayoutResponse)o;
        return Objects.equals(this.additionalData, payoutResponse.additionalData) && Objects.equals(this.authCode, payoutResponse.authCode) && Objects.equals(this.dccAmount, payoutResponse.dccAmount) && Objects.equals(this.dccSignature, payoutResponse.dccSignature) && Objects.equals(this.fraudResult, payoutResponse.fraudResult) && Objects.equals(this.issuerUrl, payoutResponse.issuerUrl) && Objects.equals(this.md, payoutResponse.md) && Objects.equals(this.paRequest, payoutResponse.paRequest) && Objects.equals(this.pspReference, payoutResponse.pspReference) && Objects.equals(this.refusalReason, payoutResponse.refusalReason) && Objects.equals((Object)this.resultCode, (Object)payoutResponse.resultCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.authCode, this.dccAmount, this.dccSignature, this.fraudResult, this.issuerUrl, this.md, this.paRequest, this.pspReference, this.refusalReason, this.resultCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    dccAmount: ").append(this.toIndentedString(this.dccAmount)).append("\n");
        sb.append("    dccSignature: ").append(this.toIndentedString(this.dccSignature)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    issuerUrl: ").append(this.toIndentedString(this.issuerUrl)).append("\n");
        sb.append("    md: ").append(this.toIndentedString(this.md)).append("\n");
        sb.append("    paRequest: ").append(this.toIndentedString(this.paRequest)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayoutResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PayoutResponse)JSON.getMapper().readValue(jsonString, PayoutResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED(String.valueOf("AuthenticationFinished")),
        AUTHENTICATIONNOTREQUIRED(String.valueOf("AuthenticationNotRequired")),
        AUTHORISED(String.valueOf("Authorised")),
        CANCELLED(String.valueOf("Cancelled")),
        CHALLENGESHOPPER(String.valueOf("ChallengeShopper")),
        ERROR(String.valueOf("Error")),
        IDENTIFYSHOPPER(String.valueOf("IdentifyShopper")),
        PARTIALLYAUTHORISED(String.valueOf("PartiallyAuthorised")),
        PENDING(String.valueOf("Pending")),
        PRESENTTOSHOPPER(String.valueOf("PresentToShopper")),
        RECEIVED(String.valueOf("Received")),
        REDIRECTSHOPPER(String.valueOf("RedirectShopper")),
        REFUSED(String.valueOf("Refused")),
        SUCCESS(String.valueOf("Success"));

        private static final Logger LOG;
        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResultCodeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResultCodeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResultCodeEnum.class.getName());
        }
    }
}

