/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.payment;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.payment.AuthenticationResultRequest;
import com.adyen.model.payment.AuthenticationResultResponse;
import com.adyen.model.payment.PaymentRequest;
import com.adyen.model.payment.PaymentRequest3d;
import com.adyen.model.payment.PaymentRequest3ds2;
import com.adyen.model.payment.PaymentResult;
import com.adyen.model.payment.ThreeDS2ResultRequest;
import com.adyen.model.payment.ThreeDS2ResultResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;

public class PaymentsApi
extends Service {
    public static final String API_VERSION = "68";
    protected String baseURL;

    public PaymentsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://pal-test.adyen.com/pal/servlet/Payment/v68");
    }

    public PaymentsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public PaymentResult authorise(PaymentRequest paymentRequest) throws ApiException, IOException {
        return this.authorise(paymentRequest, null);
    }

    public PaymentResult authorise(PaymentRequest paymentRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    public PaymentResult authorise3d(PaymentRequest3d paymentRequest3d) throws ApiException, IOException {
        return this.authorise3d(paymentRequest3d, null);
    }

    public PaymentResult authorise3d(PaymentRequest3d paymentRequest3d, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentRequest3d.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise3d", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    public PaymentResult authorise3ds2(PaymentRequest3ds2 paymentRequest3ds2) throws ApiException, IOException {
        return this.authorise3ds2(paymentRequest3ds2, null);
    }

    public PaymentResult authorise3ds2(PaymentRequest3ds2 paymentRequest3ds2, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = paymentRequest3ds2.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise3ds2", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    public AuthenticationResultResponse getAuthenticationResult(AuthenticationResultRequest authenticationResultRequest) throws ApiException, IOException {
        return this.getAuthenticationResult(authenticationResultRequest, null);
    }

    public AuthenticationResultResponse getAuthenticationResult(AuthenticationResultRequest authenticationResultRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = authenticationResultRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/getAuthenticationResult", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return AuthenticationResultResponse.fromJson(jsonResult);
    }

    public ThreeDS2ResultResponse retrieve3ds2Result(ThreeDS2ResultRequest threeDS2ResultRequest) throws ApiException, IOException {
        return this.retrieve3ds2Result(threeDS2ResultRequest, null);
    }

    public ThreeDS2ResultResponse retrieve3ds2Result(ThreeDS2ResultRequest threeDS2ResultRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = threeDS2ResultRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/retrieve3ds2Result", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ThreeDS2ResultResponse.fromJson(jsonResult);
    }
}

