/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.CreateMerchantRequest;
import com.adyen.model.management.CreateMerchantResponse;
import com.adyen.model.management.ListMerchantResponse;
import com.adyen.model.management.Merchant;
import com.adyen.model.management.RequestActivationResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class AccountMerchantLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public AccountMerchantLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public AccountMerchantLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public CreateMerchantResponse createMerchantAccount(CreateMerchantRequest createMerchantRequest) throws ApiException, IOException {
        return this.createMerchantAccount(createMerchantRequest, null);
    }

    public CreateMerchantResponse createMerchantAccount(CreateMerchantRequest createMerchantRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = createMerchantRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CreateMerchantResponse.fromJson(jsonResult);
    }

    public Merchant getMerchantAccount(String merchantId) throws ApiException, IOException {
        return this.getMerchantAccount(merchantId, null);
    }

    public Merchant getMerchantAccount(String merchantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Merchant.fromJson(jsonResult);
    }

    public ListMerchantResponse listMerchantAccounts() throws ApiException, IOException {
        return this.listMerchantAccounts(null, null, null);
    }

    public ListMerchantResponse listMerchantAccounts(Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListMerchantResponse.fromJson(jsonResult);
    }

    public RequestActivationResponse requestToActivateMerchantAccount(String merchantId) throws ApiException, IOException {
        return this.requestToActivateMerchantAccount(merchantId, null);
    }

    public RequestActivationResponse requestToActivateMerchantAccount(String merchantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/activate", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return RequestActivationResponse.fromJson(jsonResult);
    }
}

