/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.ApproveTransferLimitRequest;
import com.adyen.model.balanceplatform.CreateTransferLimitRequest;
import com.adyen.model.balanceplatform.LimitStatus;
import com.adyen.model.balanceplatform.Scope;
import com.adyen.model.balanceplatform.TransferLimit;
import com.adyen.model.balanceplatform.TransferLimitListResponse;
import com.adyen.model.balanceplatform.TransferType;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TransferLimitsBalanceAccountLevelApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public TransferLimitsBalanceAccountLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public TransferLimitsBalanceAccountLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public void approvePendingTransferLimits(String id, ApproveTransferLimitRequest approveTransferLimitRequest) throws ApiException, IOException {
        this.approvePendingTransferLimits(id, approveTransferLimitRequest, null);
    }

    public void approvePendingTransferLimits(String id, ApproveTransferLimitRequest approveTransferLimitRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = approveTransferLimitRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}/transferLimits/approve", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    }

    public TransferLimit createTransferLimit(String id, CreateTransferLimitRequest createTransferLimitRequest) throws ApiException, IOException {
        return this.createTransferLimit(id, createTransferLimitRequest, null);
    }

    public TransferLimit createTransferLimit(String id, CreateTransferLimitRequest createTransferLimitRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = createTransferLimitRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}/transferLimits", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return TransferLimit.fromJson(jsonResult);
    }

    public void deletePendingTransferLimit(String transferLimitId, String id) throws ApiException, IOException {
        this.deletePendingTransferLimit(transferLimitId, id, null);
    }

    public void deletePendingTransferLimit(String transferLimitId, String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (transferLimitId == null) {
            throw new IllegalArgumentException("Please provide the transferLimitId path parameter");
        }
        pathParams.put("transferLimitId", transferLimitId);
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}/transferLimits/{transferLimitId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public TransferLimitListResponse getCurrentTransferLimits(String id) throws ApiException, IOException {
        return this.getCurrentTransferLimits(id, null, null, null);
    }

    public TransferLimitListResponse getCurrentTransferLimits(String id, Scope scope, TransferType transferType, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (scope != null) {
            queryParams.put("scope", scope.toString());
        }
        if (transferType != null) {
            queryParams.put("transferType", transferType.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}/transferLimits/current", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TransferLimitListResponse.fromJson(jsonResult);
    }

    public TransferLimit getSpecificTransferLimit(String transferLimitId, String id) throws ApiException, IOException {
        return this.getSpecificTransferLimit(transferLimitId, id, null);
    }

    public TransferLimit getSpecificTransferLimit(String transferLimitId, String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (transferLimitId == null) {
            throw new IllegalArgumentException("Please provide the transferLimitId path parameter");
        }
        pathParams.put("transferLimitId", transferLimitId);
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}/transferLimits/{transferLimitId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransferLimit.fromJson(jsonResult);
    }

    public TransferLimitListResponse getTransferLimits(String id) throws ApiException, IOException {
        return this.getTransferLimits(id, null, null, null, null);
    }

    public TransferLimitListResponse getTransferLimits(String id, Scope scope, TransferType transferType, LimitStatus status, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (scope != null) {
            queryParams.put("scope", scope.toString());
        }
        if (transferType != null) {
            queryParams.put("transferType", transferType.toString());
        }
        if (status != null) {
            queryParams.put("status", status.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balanceAccounts/{id}/transferLimits", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TransferLimitListResponse.fromJson(jsonResult);
    }
}

