/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.Message;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"errorFields", "errorMessage", "modificationMerchantReference", "modificationPspReference", "paymentMerchantReference", "paymentPspReference"})
public class PaymentFailureNotificationContent {
    public static final String JSON_PROPERTY_ERROR_FIELDS = "errorFields";
    private List<ErrorFieldType> errorFields = null;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private Message errorMessage;
    public static final String JSON_PROPERTY_MODIFICATION_MERCHANT_REFERENCE = "modificationMerchantReference";
    private String modificationMerchantReference;
    public static final String JSON_PROPERTY_MODIFICATION_PSP_REFERENCE = "modificationPspReference";
    private String modificationPspReference;
    public static final String JSON_PROPERTY_PAYMENT_MERCHANT_REFERENCE = "paymentMerchantReference";
    private String paymentMerchantReference;
    public static final String JSON_PROPERTY_PAYMENT_PSP_REFERENCE = "paymentPspReference";
    private String paymentPspReference;

    public PaymentFailureNotificationContent errorFields(List<ErrorFieldType> errorFields) {
        this.errorFields = errorFields;
        return this;
    }

    public PaymentFailureNotificationContent addErrorFieldsItem(ErrorFieldType errorFieldsItem) {
        if (this.errorFields == null) {
            this.errorFields = new ArrayList<ErrorFieldType>();
        }
        this.errorFields.add(errorFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Missing or invalid fields that caused the payment error.")
    @JsonProperty(value="errorFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getErrorFields() {
        return this.errorFields;
    }

    @JsonProperty(value="errorFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorFields(List<ErrorFieldType> errorFields) {
        this.errorFields = errorFields;
    }

    public PaymentFailureNotificationContent errorMessage(Message errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Message getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorMessage(Message errorMessage) {
        this.errorMessage = errorMessage;
    }

    public PaymentFailureNotificationContent modificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The `reference` of the capture or refund.")
    @JsonProperty(value="modificationMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModificationMerchantReference() {
        return this.modificationMerchantReference;
    }

    @JsonProperty(value="modificationMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
    }

    public PaymentFailureNotificationContent modificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
        return this;
    }

    @ApiModelProperty(value="The `pspReference` of the capture or refund.")
    @JsonProperty(value="modificationPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModificationPspReference() {
        return this.modificationPspReference;
    }

    @JsonProperty(value="modificationPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
    }

    public PaymentFailureNotificationContent paymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The `reference` of the payment.")
    @JsonProperty(value="paymentMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMerchantReference() {
        return this.paymentMerchantReference;
    }

    @JsonProperty(value="paymentMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
    }

    public PaymentFailureNotificationContent paymentPspReference(String paymentPspReference) {
        this.paymentPspReference = paymentPspReference;
        return this;
    }

    @ApiModelProperty(value="The `pspReference` of the payment.")
    @JsonProperty(value="paymentPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentPspReference() {
        return this.paymentPspReference;
    }

    @JsonProperty(value="paymentPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentPspReference(String paymentPspReference) {
        this.paymentPspReference = paymentPspReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentFailureNotificationContent paymentFailureNotificationContent = (PaymentFailureNotificationContent)o;
        return Objects.equals(this.errorFields, paymentFailureNotificationContent.errorFields) && Objects.equals(this.errorMessage, paymentFailureNotificationContent.errorMessage) && Objects.equals(this.modificationMerchantReference, paymentFailureNotificationContent.modificationMerchantReference) && Objects.equals(this.modificationPspReference, paymentFailureNotificationContent.modificationPspReference) && Objects.equals(this.paymentMerchantReference, paymentFailureNotificationContent.paymentMerchantReference) && Objects.equals(this.paymentPspReference, paymentFailureNotificationContent.paymentPspReference);
    }

    public int hashCode() {
        return Objects.hash(this.errorFields, this.errorMessage, this.modificationMerchantReference, this.modificationPspReference, this.paymentMerchantReference, this.paymentPspReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentFailureNotificationContent {\n");
        sb.append("    errorFields: ").append(this.toIndentedString(this.errorFields)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    modificationMerchantReference: ").append(this.toIndentedString(this.modificationMerchantReference)).append("\n");
        sb.append("    modificationPspReference: ").append(this.toIndentedString(this.modificationPspReference)).append("\n");
        sb.append("    paymentMerchantReference: ").append(this.toIndentedString(this.paymentMerchantReference)).append("\n");
        sb.append("    paymentPspReference: ").append(this.toIndentedString(this.paymentPspReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentFailureNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentFailureNotificationContent)JSON.getMapper().readValue(jsonString, PaymentFailureNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

